;; timing test for generalized ref/set!

(define invert-matrix
  (let ((+documentation+ "(invert-matrix matrix b (zero 1.0e-7)) inverts 'matrix'"))
    (lambda* (matrix b (zero 1.0e-7))
      ;; translated from Numerical Recipes (gaussj)
      (call-with-exit
       (lambda (return)
	 (let ((n (car (vector-dimensions matrix))))
	   (let ((cols (make-vector n 0))
		 (rows (make-vector n 0))
		 (pivots (make-vector n 0)))
	     (do ((i 0 (+ i 1))
		  (col 0 0)
		  (row 0 0))
		 ((= i n))
	       (do ((biggest 0)
		    (j 0 (+ j 1)))
		   ((= j n)
		    (if (< biggest zero) 
			(return #f)))
		 (if (not (= (pivots j) 1))
		     (do ((k 0 (+ k 1)))
			 ((= k n))
		       (if (= (pivots k) 0)
			   (let ((val (abs (matrix j k))))
			     (if (> val biggest)
				 (begin
				   (set! col k)
				   (set! row j)
				   (set! biggest val))))
			   (if (> (pivots k) 1)
			       (return #f))))))
	       (set! (pivots col) (+ (pivots col) 1))
	       (if (not (= row col))
		   (let ((temp (if (sequence? b) (b row) 0)))
		     (if (sequence? b)
			 (begin
			   (set! (b row) (b col))
			   (set! (b col) temp)))
		     (do ((k 0 (+ k 1)))
			 ((= k n))
		       (set! temp (matrix row k))
		       (set! (matrix row k) (matrix col k))
		       (set! (matrix col k) temp))))
	       (set! (cols i) col)
	       (set! (rows i) row)
	       ;; round-off troubles here
	       (if (< (abs (matrix col col)) zero)
		   (return #f))
	       (let ((inverse-pivot (/ 1 (matrix col col))))
		 (set! (matrix col col) 1)
		 (do ((k 0 (+ k 1)))
		     ((= k n))
		   (set! (matrix col k) (* inverse-pivot (matrix col k))))
		 (if b (set! (b col) (* inverse-pivot (b col)))))
	       (do ((k 0 (+ k 1)))
		   ((= k n))
		 (if (not (= k col))
		     (let ((scl (matrix k col)))
		       (set! (matrix k col) 0)
		       (do ((m 0 (+ 1 m)))
			   ((= m n))
			 (set! (matrix k m) (- (matrix k m) (* scl (matrix col m)))))
		       (if b (set! (b k) (- (b k) (* scl (b col)))))))))
	     (do ((i (- n 1) (- i 1)))
		 ((< i 0))
	       (if (not (= (rows i) (cols i)))
		   (do ((k 0 (+ k 1)))
		       ((= k n))
		     (let ((temp (matrix k (rows i))))
		       (set! (matrix k (rows i)) (matrix k (cols i)))
		       (set! (matrix k (cols i)) temp)))))
	     (list matrix b))))))))

(define (matrix-multiply A B)
  (let ((size (car (vector-dimensions A))))
    (do ((C (make-vector (list size size) 0))
         (i 0 (+ i 1)))
	((= i size) C)
      (do ((j 0 (+ j 1)))
	  ((= j size))
	(do ((sum 0)
             (k 0 (+ k 1)))
	    ((= k size)
             (set! (C i j) sum))
	  (set! sum (+ sum (* (A i k) (B k j)))))))))

;;; Rosetta scheme code + changes
(define (square-matrix mat)
  (matrix-multiply mat mat))

(define (matrix-exp mat pow)
  (cond ((= pow 0)
	 (let ((m (copy mat)))
	   (fill! m 0)
	   (let ((size (car (vector-dimensions mat))))
	     (do ((i 0 (+ i 1)))
		 ((= i size) m)
	       (set! (m i i) 1)))))
	  
	  ((= pow 1) 
	   mat)

	  ((negative? pow)
	   (let ((im (invert-matrix (matrix-exp mat (abs pow)))))
	     (and (pair? im)
		  (car im))))

	  ((even? pow)
	   (square-matrix (matrix-exp mat (/ pow 2))))
	  
	  (else
	   (matrix-multiply mat (matrix-exp mat (- pow 1))))))

(define (testm)
  (do ((i 0 (+ i 1)))
      ((= i 10000))
    (let ((v (make-vector (list 4 4)))
	  (pow (+ 1 (random 10))))
      (do ((k 0 (+ k 1)))
	  ((= k 4))
	(do ((n 0 (+ n 1)))
	    ((= n 4))
	  (set! (v k n) (- (random 50) 100))))
      (let ((mn (matrix-exp (copy v) (- pow))))
	(if mn
	    (let* ((mp (matrix-exp (copy v) pow))
		   (m1 (matrix-multiply mn mp))
		   (mx1 (m1 0 0))
		   (mx0 0.0))
	      (do ((k 1 (+ k 1)))
		  ((= k 4))
		(if (> (abs (- (m1 k k) 1)) (abs (- mx1 1)))
		    (set! mx1 (m1 k k))))
	      (do ((k 0 (+ k 1)))
		  ((= k 4))
		(do ((n 0 (+ n 1)))
		    ((= n 4))
		  (unless (= k n)
		    (if (> (abs (m1 k n)) mx0)
			(set! mx0 (abs (m1 k n)))))))
	      ))))))
  
(testm)

(#_exit)
