;;; try each s7test test macro (using repl, not snd)

(define aux-counter 0)
(system "make-repl")

(for-each
 (lambda (test-case)
   (let ((aux-file (format #f "t101-aux-~D.scm" (set! aux-counter (+ aux-counter 1)))))
     (call-with-output-file aux-file
       (lambda (p)
	 (format p "(define-macro (test tst expected) ~A)~%(load \"s7test.scm\")~%(exit)~%" test-case)))
     (format *stderr* "test: ~S~%" test-case)
     (system (string-append "./repl " aux-file))))
 (list 
  "`(ok? ',tst (lambda () (eval ',tst)) ,expected)"
  "`(ok? ',tst (lambda () ,tst) ,expected)"
  "`(ok? ',tst (let () (define (_s7_) ,tst)) ,expected)"
  "`(ok? ',tst (lambda () (let ((_s7_ #f)) (set! _s7_ ,tst))) ,expected)"
  "`(ok? ',tst (lambda () (let ((_s7_ ,tst)) _s7_)) ,expected)"
  "`(ok? ',tst (catch #t (lambda () (lambda* ((_a_ ,tst)) _a_)) (lambda any (lambda () 'error))) ,expected)"
  "`(ok? ',tst (lambda () (do ((_a_ ,tst)) (#t _a_))) ,expected)"
  "`(ok? ',tst (lambda () (do ((__i__ 0 (+ __i__ 1))) ((= __i__ 1) ,expected) ,tst)) ,expected)"
  "`(ok? ',tst (lambda () (define ($f$) (let (($v$ (vector #f))) (do (($i$ 0 (+ $i$ 1))) ((= $i$ 1) ($v$ 0)) (vector-set! $v$ 0 ,tst)))) ($f$)) ,expected)"
  "`(ok? ',tst (lambda () (define ($f$) (let (($v$ #f)) (do (($i$ 0 (+ $i$ 1))) ((= $i$ 1) $v$) (set! $v$ ,tst)))) ($f$)) ,expected)"
  "`(ok? ',tst (lambda () (define ($f$) (let ((x (map (lambda (a) ,tst) '(0)))) (car x))) ($f$)) ,expected)"
  "`(ok? ',tst (lambda () (call-with-exit (lambda (_a_) (_a_ ,tst)))) ,expected)"
  "`(ok? ',tst (lambda () (call/cc (lambda (_a_) (_a_ ,tst)))) ,expected)"
  "`(ok? ',tst (lambda () (values ,tst)) ,expected)"
  "`(ok? ',tst (lambda () ((lambda (a b) b) (values #f ,tst))) ,expected)"
  "`(ok? ',tst (lambda () (define (_s7_ _a_) _a_) (_s7_ ,tst)) ,expected)"
  "`(ok? ',tst (lambda () (let ((___x #f)) (set! ___x ,tst))) ,expected)"
  "`(ok? ',tst (lambda () (let ((___x #(#f))) (set! (___x 0) ,tst))) ,expected)"
  "`(ok? ',tst (lambda () (let ((___x #(#f))) (vector-set! ___x 0 ,tst))) ,expected)"
  "`(ok? ',tst (lambda () (define* (_s7_ (_a_ #f)) (or _a_)) (_s7_ ,tst)) ,expected)"
  "`(ok? ',tst (lambda () (dynamic-wind (lambda () #f) (lambda () ,tst) (lambda () #f))) ,expected)"
  "`(ok? ',tst (lambda () (caadr (catch 'receive (lambda () (throw 'receive ,tst)) (lambda any any)))) ,expected)"
  "`(ok? ',tst (lambda () (stacktrace (- (random 100) 50) (- (random 100) 50) (- (random 100) 50) (- (random 100) 50) (> (random 100) 50)) ,tst) ,expected)"
  "({list} 'ok? ({list} quote tst) ({list} lambda () tst) expected)"
  ))

(format *stderr* "~NC ffitest ~NC~%" 20 #\- 20 #\-)
(if (provided? 'linux)
    (begin
      (system "gcc -o ffitest ffitest.c -g -Wall s7.o -lm -I. -ldl")
      (system "ffitest"))
    (if (provided? 'freebsd)
	(begin
	  (system "cc -o ffitest ffitest.c -g -Wall s7.o -lm -I. -ldl")
	  (system "ffitest"))
	(if (provided? 'osx)
	    (begin
	      (system "gcc -o ffitest ffitest.c -g -Wall s7.o -lm -I.")
	      (system "ffitest"))
	    )))
    

(format *stderr* "~%~NC lint ~NC~%" 20 #\- 20 #\-)
(catch #t (lambda () (lint "s7test.scm" #f)) (lambda args #f))

;; lint clobbers reader-cond
(define-expansion (reader-cond . clauses)
  (call-with-exit
   (lambda (return)
     (for-each
      (lambda (clause)
	(let ((val (eval (car clause))))
	  (if val
	      (if (null? (cdr clause)) (return val)
		  (if (null? (cddr clause)) (return (cadr clause))
		      (return (apply values (map quote (cdr clause)))))))))
      clauses)
     (values))))

(format *stderr* "~%~NC local s7test ~NC~%" 20 #\- 20 #\-)
(system "./snd -e '(let () (catch #t (lambda () (load \"s7test.scm\" (curlet))) (lambda args #f)) (exit))'")

(format *stderr* "~NC tcopy ~NC~%" 20 #\- 20 #\-)
(system "./repl tcopy.scm")

(format *stderr* "~NC tmap ~NC~%" 20 #\- 20 #\-)
(system "./repl tmap.scm")

(format *stderr* "~NC teq ~NC~%" 20 #\- 20 #\-)
(system "./repl teq.scm")

(format *stderr* "~NC titer ~NC~%" 20 #\- 20 #\-)
(system "./repl titer.scm")

(format *stderr* "~%~NC tform ~NC~%" 20 #\- 20 #\-)
(system "./repl tform.scm")

(format *stderr* "~%~NC thash ~NC~%" 20 #\- 20 #\-)
(system "./repl thash.scm")

(format *stderr* "~NC tauto ~NC~%" 20 #\- 20 #\-)
(system "./repl tauto.scm")

(format *stderr* "~NC index ~NC~%" 20 #\- 20 #\-)
(system "./snd make-index.scm")

(format *stderr* "~NC makexg ~NC~%" 20 #\- 20 #\-)
(system "./snd makexg.scm")

(format *stderr* "~NC makegl ~NC~%" 20 #\- 20 #\-)
(system "./snd makegl.scm")

(format *stderr* "~NC tgen ~NC~%" 20 #\- 20 #\-)
(system "./snd tgen.scm")

(format *stderr* "~NC tall ~NC~%" 20 #\- 20 #\-)
(system "./snd tall.scm")

(format *stderr* "~NC snd-test ~NC~%" 20 #\- 20 #\-)
(system "./snd -l snd-test.scm")

(format *stderr* "~NC bench ~NC~%" 20 #\- 20 #\-)
(system "(cd /home/bil/test/bench/src ; /home/bil/cl/snd test-all.scm)")

(format *stderr* "~NC lg ~NC~%" 20 #\- 20 #\-)
(system "./repl lg.scm")

(exit)
