/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* $Id: smtpguard-daemon.h,v 1.1.1.1 2005/11/04 07:19:35 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#ifndef _SMTPGUARD_DAEMON_H
#define _SMTPGUARD_DAEMON_H

#include <smtpguard/smtpguard.h>
#include <smtpguard/eval.h>
#include <smtpguard/idb.h>
#include <smtpguard/sg_log.h>
#include <smtpguard/sg_time.h>

#include <glib.h>

#define QUEUELIMIT	120*2
#define BUFFSIZE	1024
#define SG_DBHOME	"SMTPGUARD_DBHOME"
#define SG_DBNAME	"SMTPGUARD_DBNAME"
#define EXPIRE_SPAN	1

char	*mailfrom;
char	*sendmail;
char	*hostname;
int	expire;

int	opt_noaction;

void disp_data (char *data, int length);

#ifndef FG_DISABLE_DEPRECATED
SmtpInfoData *analyze_smtp_data_xml (char *xmlstr);
#endif

int evalguard_init (char *config, spam_context_t *ctx, spam_def_t **spamdef);
int evalguard_calc (spam_context_t *ctx, spam_def_t *spamdef,
                    FGSmtpInfo *fsi, idb_data_t *d);
int mailwarn (char *rcptto, FGSmtpInfo *fsi, idb_data_t *d);
void mailwarn_handle (int signum);
int make_send_data (char *buf, FGSmtpInfo *fsi);
void disp_point (FGSmtpInfo *fsi, idb_data_t *d);
idb_data_t *search_db (idb_t *idb, FGSmtpInfo *fsi);
int update_db (idb_t *idb, idb_data_t *d, int flg);
int remove_dir (char *dirname);


// little evil. why is this definition here?
spam_def_t *spam_parse_def (FILE *fin, spam_context_t *ctx);
void spam_free_def (spam_def_t *def);

/* smtpguard-db.c */
void disp_smtpdb_data (FGSmtpInfo *fsi, idb_data_t *d);

#endif
