/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* $Id: evalguard.c,v 1.1.1.1 2005/11/04 07:19:34 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>

#include "smtpguard.h"
#include "smtpguard-daemon.h"
#include "idbdata.h"


#define EVAL_ASSERT(arg_list, name) \
	if (arg_list[0] == NULL) { \
		sg_err(0, eval_assert_msg, name); \
		exit(2); \
	}

struct rulemap_s {
	char *name;
	int value;
};

// ٥뤬'A'ιԤϤĤͤɾоݤȤʤ롣
// ٥뤬'R'ιԤϡǸ˷̤֤ɾ롣

static int
lookup_ruleid (const char *name)
{
	int i;
	static struct rulemap_s rulemap[] =
	{
		{  "R", SPAM_RULE_RESULT },
		{  "A", SPAM_RULE_ALL },
	};

	sg_debug (2, "lookup_ruleid: %s",name);
	
	for ( i = 0; i < sizeof (rulemap) / sizeof (struct rulemap_s); i++ ) {
		if( !strcmp ( rulemap[i].name, name )) {
			return rulemap[i].value;
		}
	}

	return -1;
}

// IP: IPɥ쥹
// F:  MAILFROMʸ
// T:  RCPTTOʸ
// C:  RELAYCLIENTꤵƤ뤫ɤ
//     1-ꤵƤ
//     0-ꤵƤʤ
// H:  RCPTTOΥɥᥤrcpthostsϿƤ뤫ɤ
//     1-ϿƤ
//     0-ϿƤʤ
// SC: ץå
// FC: MAILFROM
// TC: RCPTTO
// P: ץݥȿ

struct eval_context
{
	FGSmtpInfo *smtpdata;
	idb_data_t *dbdata;
	unsigned int Plocal;
	unsigned int ok;
	unsigned int delete;
	unsigned int modified;
};

#define MYCTX(ctx) ((struct eval_context *)(ctx)->private_ctx)

static spam_eval_t
spam_context_variable (const char *name, spam_context_t *ctx)
{	
	char *str;
	FGSmtpInfo *fsi = MYCTX(ctx)->smtpdata;
	

	if ( ! strcmp ( name, "IP" ) ) {
		sg_debug(2, "spam_context_variable: %s %s", name,
			 fg_smtp_info_get_addr(fsi));
		return spam_eval_build_string( fg_smtp_info_get_addr(fsi) );
	} else if ( ! strcmp ( name, "F" ) ) {
		sg_debug(2, "spam_context_variable: %s %s", name,
			 fg_smtp_info_get_mailfrom(fsi));
		return spam_eval_build_string( fg_smtp_info_get_mailfrom(fsi) );
	} else if ( ! strcmp ( name, "FD" ) ) {
		str = strrchr(fg_smtp_info_get_mailfrom(fsi), '@');
		if( str ) {
			sg_debug(2, "spam_context_variable: %s %s", name, str+1);
			return spam_eval_build_string(str+1 );
		}
		else {
			sg_debug(2, "spam_context_variable: %s %s", name,
				 fg_smtp_info_get_mailfrom(fsi));
			return spam_eval_build_string( fg_smtp_info_get_mailfrom(fsi) );
		}			
	} else if ( ! strcmp ( name, "T" ) ) {
		sg_debug(2, "spam_context_variable: %s %s", name,
			 fg_smtp_info_get_rcptto(fsi));
		return spam_eval_build_string( fg_smtp_info_get_rcptto(fsi) );
	} else if ( ! strcmp ( name, "TD" ) ) {
		str = strrchr( fg_smtp_info_get_rcptto(fsi), '@');
		if( str ) {
			sg_debug(2, "spam_context_variable: %s %s", name, str+1);
			return spam_eval_build_string(str+1);
		}
		else {
			sg_debug(2, "spam_context_variable: %s %s", name,
				 fg_smtp_info_get_rcptto(fsi));
			return spam_eval_build_string( fg_smtp_info_get_rcptto(fsi) );
		}
	} else if ( ! strcmp ( name, "C" ) ) {
		sg_debug(2, "spam_context_variable: %s %d", name,
			 fg_smtp_info_is_mynetworks (fsi));
		return spam_eval_build_number( fg_smtp_info_is_mynetworks (fsi) );
	} else if ( ! strcmp ( name, "H" ) ) {
		sg_debug(2, "spam_context_variable: %s %d", name,
			 fg_smtp_info_is_mydestination (fsi));
		return spam_eval_build_number( fg_smtp_info_is_mydestination (fsi) );
	} else if ( ! strcmp ( name, "SC" ) ) {
		sg_debug(2, "spam_context_variable: %s %d", name, MYCTX(ctx)->dbdata->SC);
		return spam_eval_build_number( MYCTX(ctx)->dbdata->SC );
	} else if ( ! strcmp ( name, "FC" ) ) {
		sg_debug(2, "spam_context_variable: %s %d", name, MYCTX(ctx)->dbdata->FC);
		return spam_eval_build_number( MYCTX(ctx)->dbdata->FC );
	} else if ( ! strcmp ( name, "TC" ) ) {
		sg_debug(2, "spam_context_variable: %s %d", name,  MYCTX(ctx)->dbdata->TC);
		return spam_eval_build_number( MYCTX(ctx)->dbdata->TC );
	} else if ( ! strcmp ( name, "P" ) ) {
		sg_debug(2, "spam_context_variable: %s %d", name,  MYCTX(ctx)->dbdata->P);
		return spam_eval_build_number( MYCTX(ctx)->dbdata->P );
	} else {
		sg_err(0, "spam_context_variable: Unknown variable name, returning false: %s", name );
		return spam_eval_build_bool( 0 );
	}
}

static spam_eval_t
spam_context_assign (const char *name, spam_context_t *ctx, spam_eval_t *val)
{
	int num = 0;
	
	if ( ! strcmp ( name, "IP" ) ||
	     ! strcmp ( name, "F" ) ||
	     ! strcmp ( name, "FD" ) ||
	     ! strcmp ( name, "T" ) ||
	     ! strcmp ( name, "TD" ) ||
	     ! strcmp ( name, "C" ) ||
	     ! strcmp ( name, "H" ) ||
	     ! strcmp ( name, "SC" ) ||
	     ! strcmp ( name, "FC" ) ||
	     ! strcmp ( name, "TC" ) ||
	     ! strcmp ( name, "P" ) ) {
		sg_err(0, "spam_context_assign: Read only variable, returning false: %s", name);
		return spam_eval_build_bool( 0 );
	} else if ( ! strcmp ( name, "MAILFROM" ) ) {
		mailfrom = strdup (val->node.string);
	} else if ( ! strcmp ( name, "SENDMAIL" ) ) {
		sendmail = strdup (val->node.string);
	} else if ( ! strcmp ( name, "EXPIRE" ) ) {
		expire = val->node.number;
		num = 1;
	} else {
		sg_err(0, "spam_context_assign: Unknown variable name in assign, returning false: %s", name);
		return spam_eval_build_bool( 0 );
	}

	if (num)
		sg_debug(2, "spam_context_assign: %s %d",name,val->node.number);
	else
		sg_debug(2, "spam_context_assign: %s %s",name,val->node.string);
	
	return *val;
}

// o 
//   ݥȲû(Pؤβû)
// o +
//   ݥȲû
//   ɾåˤơݥ(P)˰Ū˲û롣
// o ok
//   ³ԡ
//   饤ȤϽ³Ԥ롣
// o wait WAITTIME
//   ٱ䡣
//   饤ȤϡSMTPޥɤWAITTIMEΥȤ롣
// o reject MESSAGE
//   ݡ
//   饤ȤMESSAGEäƼݤ롣
// o mail [ADDRESS]
//   ADDRESS ˷ٹ᡼롣
// o log MESSAGE
//   MESSAGE Ϥ(multilog)
// o expire SECONDS
//   Υǡͭ¤ SECONDSñĹ롣
// o delete
//   Υ쥳ɤ롣

static spam_eval_t
spam_context_funccall (const char *name, spam_context_t *ctx,
                       spam_eval_t **arg_list)
{

	int i = 0;
        char *eval_assert_msg = "spam_context_funccall: config syntax error. No argument is specified for \"%s\".";
	FGSmtpInfo *fsi = MYCTX(ctx)->smtpdata;
	
	if (!strcmp( name,"ok")) {

		sg_debug(1, "%s: %s", fg_smtp_info_get_addr(fsi), name);
	
		MYCTX(ctx)->ok = 1;
		if (fg_smtp_info_get_action_message(fsi)) {
			fg_smtp_info_delete_action (fsi);
		}

	} else if ( ! strcmp ( name, "add" ) ) {

		EVAL_ASSERT(arg_list, name);

		sg_debug(1, "%s: add %d", fg_smtp_info_get_addr(fsi), arg_list[0]->node.number);

		MYCTX(ctx)->dbdata->P += arg_list[0]->node.number;
		MYCTX(ctx)->modified = 1;

	} else if ( ! strcmp ( name, "addlocal" ) ) {

		EVAL_ASSERT(arg_list, name);

		sg_debug(1, "%s: addlocal %d", fg_smtp_info_get_addr(fsi), arg_list[0]->node.number);

		MYCTX(ctx)->dbdata->P += arg_list[0]->node.number;
		MYCTX(ctx)->Plocal += arg_list[0]->node.number;

	} else if ( ! strcmp ( name, "wait" ) ) {

		EVAL_ASSERT(arg_list, name);

		sg_debug(1, "%s: wait %d", fg_smtp_info_get_addr(fsi), arg_list[0]->node.number);

		if (fg_smtp_info_get_wait (fsi) != arg_list[0]->node.number) {
			fg_smtp_info_set_wait (fsi, arg_list[0]->node.number);
			MYCTX(ctx)->modified = 1;
		}
		
	} else if ( ! strcmp ( name, "extendexpire" ) ) {

		EVAL_ASSERT(arg_list, name);

		sg_debug(1, "%s: extendexpire %d", fg_smtp_info_get_addr(fsi), arg_list[0]->node.number);

		MYCTX(ctx)->dbdata->xtime += arg_list[0]->node.number;
		MYCTX(ctx)->modified = 1;

	} else if (!strcmp( name,"reject")) {

		EVAL_ASSERT(arg_list, name);

		sg_debug(1, "%s: reject %s", fg_smtp_info_get_addr(fsi), arg_list[0]->node.string);

		MYCTX(ctx)->modified = 1;
		/* FIXME: still not implemented */
		fg_smtp_info_set_action_message (fsi, (gchar *)arg_list[0]->node.string);
		if (! fg_smtp_info_get_action_message (fsi))
			sg_err(errno, "spam_context_funccall: message strdup failed");

	} else if (!strcmp( name,"mail")) {

		EVAL_ASSERT(arg_list, name);

		sg_debug(1, "%s: mail warning to %s",
			 fg_smtp_info_get_addr(fsi), arg_list[0]->node.string);
		if (! opt_noaction && (!(MYCTX(ctx)->dbdata->status & STATUS_MAILSENT)))
			if (mailwarn((char *)arg_list[0]->node.string, MYCTX(ctx)->smtpdata, MYCTX(ctx)->dbdata) == 0) {
				MYCTX(ctx)->dbdata->status |= STATUS_MAILSENT;
				MYCTX(ctx)->modified = 1;
			}
		
	} else if (!strcmp( name,"log")) {

		EVAL_ASSERT(arg_list, name);

		sg_info_head(0, "log: ");
		while (arg_list[i] != NULL) {
                	switch( arg_list[i]->type ) {
	               		case SPAM_EVAL_BOOL:
	                        	sg_info_body(0, "%s", (arg_list[i]->node.number)?"true":"false");
	                        	break;
	                	case SPAM_EVAL_NUMBER:
	                        	sg_info_body(0, "%d", arg_list[i]->node.number );
	                        	break;
	                	case SPAM_EVAL_STRING:
	                        	sg_info_body(0, "%s", arg_list[i]->node.string );
	                        	break;
	                	default:
	                        	sg_err(0, "spam_context_funccall: unknown argument");
	                        	break;
			}
			i++;
		}
		sg_info_tail (0, "");

	} else if (!strcmp (name,"delete")) {

		sg_debug(1, "%s: %s", fg_smtp_info_get_addr(fsi), name);
	
		MYCTX(ctx)->delete = 1;

	} else {
		sg_err (0, "spam_context_funccall: Unknown func name: %s", name);
	}

	return spam_eval_build_bool (1);	
}

static spam_context_t
spam_context_init (void)
{
	spam_context_t ctx = { NULL };
	ctx.private_ctx = (void *)malloc (sizeof (struct eval_context));
	ctx.variable = spam_context_variable;
	ctx.assign = spam_context_assign;
	ctx.func_call = spam_context_funccall;
	ctx.lookup_ruleid = lookup_ruleid;
	return ctx;
}

static void
spam_context_term (spam_context_t *ctx)
{
	free(ctx->private_ctx);
}

int
evalguard_init (char *config, spam_context_t *ctx, spam_def_t **spamdef)
{
	FILE *fp;

	// in case we are to reread the config file
	if (expire) {
		spam_context_term(ctx);
        if(mailfrom)
            free (mailfrom);
		mailfrom = NULL;
        if (sendmail)
            free (sendmail);
		sendmail = NULL;
		expire = 0;
	}

	*ctx = spam_context_init();
	
	if (( fp = fopen(config,"r")) == NULL) {
		sg_err(errno, "evalguard_init: fopen(%s)", config);
		return -1;
	}

	if ( ( *spamdef = spam_parse_def( fp, ctx ) ) == NULL ) {
		sg_err(0, "evalguard_init: Can't parse definition");
		if (fclose(fp) < 0) {
			sg_err(errno, "evalguard_init: fclose()");
		}
		return -1;
	}

	if (fclose(fp) < 0) {
		sg_err(errno, "evalguard_init: fclose()");
	}

	if (!mailfrom) {
		sg_err(0, "evalguard_init: mailfrom is unset");
		return -1;
	}
	if (!sendmail) {
		sg_err(0, "evalguard_init: sendmail is unset");
		return -1;
	}
	if (!expire) {
		sg_err(0, "evalguard_init: expire is unset");
		return -1;
	}

	return 0;
}

//  0: no change in DB data
//  1: change in DB data
//  2: delete DB data
// -1: failure

int
evalguard_calc (spam_context_t *ctx, spam_def_t *spamdef,
                FGSmtpInfo *fsi, idb_data_t *d)
{
	int c, ruletype = SPAM_RULE_ALL;
	unsigned int Porig = d->P;

	// init 
	MYCTX(ctx)->smtpdata = fsi;
	MYCTX(ctx)->dbdata = d;
	MYCTX(ctx)->Plocal = 0;
	MYCTX(ctx)->ok = 0;
	MYCTX(ctx)->delete = 0;
	MYCTX(ctx)->modified = 0;

	// eval
	c = spam_ruleset_eval(ctx, spamdef, ruletype);

	// final processing
	MYCTX(ctx)->dbdata->P -= MYCTX(ctx)->Plocal;

	if (MYCTX(ctx)->ok) {
		MYCTX(ctx)->dbdata->P = Porig;
		return 0;
	}
	else if (MYCTX(ctx)->delete)
		return 2;
	else if (MYCTX(ctx)->modified)
		return 1;
	else
		return 0;

	return 0;
}
