#! /bin/sh
#
# skeleton	example file to build /etc/init.d/ scripts.
#		This file should be used to construct scripts for /etc/init.d.
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian 
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#
# Version:	@(#)skeleton  1.9  26-Feb-2001  miquels@cistron.nl
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/smtpguard-daemon
NAME=smtpguard-daemon
DESC=smtpguard
CONFIG=/etc/smtpguard/smtpguard.conf
CHUID=smtpguard:mail

export HOSTNAME=`hostname`

test -x $DAEMON || exit 0

# Include smtpguard defaults if available
if [ -f /etc/default/smtpguard ] ; then
	. /etc/default/smtpguard
fi

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon -m -b --start --quiet --pidfile /var/run/$NAME.pid \
		-c $CHUID --exec $DAEMON -- $DAEMON_OPTS $CONFIG
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --stop --quiet --pidfile /var/run/$NAME.pid \
		-c $CHUID --exec $DAEMON
	echo "$NAME."
	;;
  reload)
	echo "Reloading $DESC configuration files."
	start-stop-daemon --stop --signal 1 --quiet --pidfile \
	/var/run/$NAME.pid -c $CHUID --exec $DAEMON
	;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	echo -n "Restarting $DESC: "
	start-stop-daemon --stop --quiet --pidfile \
		/var/run/$NAME.pid -c $CHUID --exec $DAEMON
	sleep 3
	start-stop-daemon -b --start --quiet --pidfile \
		/var/run/$NAME.pid -c $CHUID --exec $DAEMON -- $DAEMON_OPTS $CONFIG
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
