/***************************************************************************
 * world_sprite_manager.cpp  -  World Sprite Manager
 *
 * Copyright (C) 2008 - 2009 Florian Richter
 ***************************************************************************/
/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "../overworld/world_sprite_manager.h"
#include "../core/game_core.h"

namespace SMC
{

/* *** *** *** *** *** *** cWorld_Sprite_Manager *** *** *** *** *** *** *** *** *** *** *** */

cWorld_Sprite_Manager :: cWorld_Sprite_Manager( cOverworld *origin )
: cSprite_Manager( 500 )
{
	n_origin = origin;
}

cWorld_Sprite_Manager :: ~cWorld_Sprite_Manager( void )
{
	Delete_All();
}

void cWorld_Sprite_Manager :: Add( cSprite *sprite )
{
	// empty sprite
	if( !sprite )
	{
		return;
	}

	// no player range
	sprite->m_player_range = 0;

	// add
	cSprite_Manager::Add( sprite );

	// Add to Waypoints array
	if( sprite->m_type == TYPE_OW_WAYPOINT )
	{
		n_origin->waypoints.push_back( static_cast<cWaypoint *>(sprite) );
	}
	// Add layer line point start to the world layer
	else if( sprite->m_type == TYPE_OW_LINE_START )
	{
		n_origin->pLayer->Add( static_cast<cLayer_Line_Point_Start *>(sprite) );
	}
}

/* *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** */

} // namespace SMC
