/***************************************************************************
                          smb4kmountdialog  -  description
                             -------------------
    begin                : Mo Nov 29 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KMOUNTDIALOG_H
#define SMB4KMOUNTDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qcheckbox.h>

// KDE includes
#include <kdialogbase.h>
#include <klineedit.h>

/**
 * This class provides a dialog for mounting shares manually.
 */

class Smb4KMountDialog : public KDialogBase
{
  Q_OBJECT
  
  public:
    /**
     * The constructor.
     */
    Smb4KMountDialog( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KMountDialog();
    
  protected slots:
    /**
     * Reimplemented from KDialogBase.
     */
    void slotOk();
    
    void slotChangeInputValue( const QString&);

  private:
    /**
     * This function sets up the view.
     */
    void setupView();
    /**
     * The line edit where the user has to enter the share.
     */
    KLineEdit *m_share_input;
    /**
     * The line edit where the user can enter the IP address.
     */
    KLineEdit *m_ip_input;
    /**
     * The line edit where the user can enter the workgroup.
     */
    KLineEdit *m_workgroup_input;
    /**
     * This checkbox determines whether the share should be added to the
     * bookmarks.
     */
    QCheckBox *m_bookmark;
};

#endif
