/***************************************************************************
    smb4kbookmarkmenuwidget.cpp  - A bookmark popup menu.
                             -------------------
    begin                : Feb 04 2004
    copyright            : (C) 2004 by Franck Babin
                           (C) 2004 by Alexander Reinholdt
    email                : babinfranck@yahoo.ca
                           dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qvaluelist.h>
#include <qstringlist.h>
#include <qdir.h>

// KDE includes
#include <kpopupmenu.h>
#include <kapplication.h>
#include <klocale.h>
#include <kmessagebox.h>

// application specific includes
#include "smb4kbookmarkmenuwidget.h"
#include "smb4kbookmarkeditor.h"
#include "../core/smb4kshare.h"
#include "../core/smb4kcore.h"
#include "../core/smb4kglobal.h"

using namespace Smb4K_Global;

/**
 * The bookmark menu widget.
 */

Smb4KBookmarkMenuWidget::Smb4KBookmarkMenuWidget( QObject *parent, const char *name )
: KActionMenu( parent, name )
{
  m_collection = new KActionCollection( popupMenu(), "BookmarkMenu_ActionCollection", KGlobal::instance() );
  m_collection->setHighlightingEnabled( true );

  m_action = NULL;

  initActions();

  insertBookmarks();

  connect( smb4k_core->mounter(),         SIGNAL( updated() ),
           this,                          SLOT( slotUpdatedShareList() ) );
  connect( smb4k_core->bookmarkHandler(), SIGNAL( bookmarksUpdated() ),
           this,                          SLOT( slotBookmarksUpdated() ) );
  connect( m_collection,                  SIGNAL( actionHighlighted( KAction * ) ),
           this,                          SLOT( slotActionHighlighted( KAction * ) ) );
}


Smb4KBookmarkMenuWidget::~Smb4KBookmarkMenuWidget()
{
  if ( m_action )
  {
    delete m_action;
    m_action = NULL;
  }
}


void Smb4KBookmarkMenuWidget::initActions()
{
  KAction *edit_bookmarks = new KAction( i18n( "&Edit Bookmarks" ), "bookmark", QString::null, this, SLOT( slotEditBookmarks() ), m_collection, "bookmarks_edit_bookmarks" );
  edit_bookmarks->setGroup( "BookmarkAction" );

  this->insert( edit_bookmarks );

  popupMenu()->insertSeparator();
}


void Smb4KBookmarkMenuWidget::insertBookmarks()
{
  QValueList<Smb4KBookmark *> bookmarks = smb4k_core->bookmarkHandler()->getBookmarks();
  QStringList shareNames;

  // Due to sorting problems, we have to do this:
  for ( QValueListIterator<Smb4KBookmark *> it = bookmarks.begin(); it != bookmarks.end(); ++it )
  {
    shareNames.append( (*it)->getShare() );
  }

  shareNames.sort();

  KActionPtrList list = m_collection->actions( "Bookmarks" );

  if ( list.count() == 0 )
  {
    for ( QStringList::ConstIterator it = shareNames.begin(); it != shareNames.end(); ++it )
    {
      KAction *a = new KAction( *it, "folder", KShortcut::null(), 0, 0, m_collection, *it );
      a->setGroup( "Bookmarks" );
      connect( a, SIGNAL( activated() ), this, SLOT( slotActivated() ) );
      this->insert( a );
    }
  }
  else
  {
    for ( QStringList::ConstIterator it = shareNames.begin(); it != shareNames.end(); ++it )
    {
      bool insert = true;

      for ( KActionPtrList::ConstIterator i = list.begin(); i != list.end(); ++i )
      {
        if ( QString::compare( *it, (*i)->text() ) == 0 )
        {
          insert = false;
        }
      }

      if ( insert )
      {
        KAction *a = new KAction( *it, "folder", KShortcut::null(), 0, 0, m_collection, *it );
        a->setGroup( "Bookmarks" );
        connect( a, SIGNAL( activated() ), this, SLOT( slotActivated() ) );
      }
    }

    for ( KActionPtrList::ConstIterator it = list.begin(); it != list.end(); ++it )
    {
      if ( shareNames.find( (*it)->text() ) == shareNames.end() )
      {
        m_collection->remove( *it );
      }
    }

    list = m_collection->actions( "Bookmarks" );

    uint index = 0;

    while ( index < list.count() )
    {
      this->remove( list[index++] );
    }


    for ( QStringList::ConstIterator it = shareNames.begin(); it != shareNames.end(); ++it )
    {
      for ( KActionPtrList::ConstIterator i = list.begin(); i != list.end(); ++i )
      {
        if ( QString::compare( (*i)->text(), *it ) == 0 )
        {
          this->insert( *i );
          break;
        }
      }
    }
  }
}


/////////////////////////////////////////////////////////////////////////////
//  SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KBookmarkMenuWidget::slotUpdatedShareList()
{
  config()->setGroup( "Mount Options" );
  QString mount_prefix = config()->readPathEntry( "Default Directory", QString::null );

  KActionPtrList list = m_collection->actions( "Bookmarks" );
  QValueList<Smb4KShare *> shares = smb4k_core->mounter()->getShares();
  bool enable = true;

  if ( !list.isEmpty() )
  {
    for ( KActionPtrList::Iterator it = list.begin(); it != list.end(); ++it )
    {
      enable = true;

      if ( !shares.isEmpty() )
      {
        for ( QValueListIterator<Smb4KShare *> i = shares.begin(); i != shares.end(); ++i )
        {
          if ( QString::compare( (*it)->text().upper(), (*i)->getName().upper() ) == 0 &&
               (((int)getuid() == (*i)->getUID() && (int)getgid() == (*i)->getGID()) || (*i)->getCanonicalPath().startsWith( QDir::home().canonicalPath() ) ||
               (*i)->getCanonicalPath().startsWith( QDir( mount_prefix ).canonicalPath() )) )
          {
            enable = false;
            break;
          }
        }
      }

      (*it)->setEnabled( enable );
    }
  }
}


void Smb4KBookmarkMenuWidget::slotActivated()
{
  if ( m_action && m_action->plainText().stripWhiteSpace().startsWith( "//" ) )
  {
    QString bookmark = m_action->plainText();
    QString host = bookmark.section( "/", 2, 2 );
    QString share = bookmark.section( "/", 3, 3 );
    smb4k_core->mounter()->mountShare( QString::null, host.stripWhiteSpace(), QString::null, share.stripWhiteSpace() );
  }
}


void Smb4KBookmarkMenuWidget::slotBookmarksUpdated()
{
  insertBookmarks();
}


void Smb4KBookmarkMenuWidget::slotEditBookmarks()
{
  if ( child( "BookmarkEditor", "KDialogBase", true ) == 0 )
  {
    Smb4KBookmarkEditor *editor = new Smb4KBookmarkEditor( 0, "BookmarkEditor" );
    editor->show();
  }
}


void Smb4KBookmarkMenuWidget::slotActionHighlighted( KAction *action )
{
  m_action = action;
}

#include "smb4kbookmarkmenuwidget.moc"
