/***************************************************************************
                          smb4kbookmarkhandler  -  description
                             -------------------
    begin                : Fr Jan 9 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SMB4KBOOKMARKHANDLER_H
#define SMB4KBOOKMARKHANDLER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qvaluelist.h>

// KDE includes
#include <kconfig.h>

// Application includes
#include "smb4kbookmark.h"


/**
 * This class belongs the to core classes of Smb4K and manages the
 * bookmarks.
 *
 * @author         Alexander Reinholdt <dustpuppy@mail.berlios.de>
 */

class Smb4KBookmarkHandler : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     */
    Smb4KBookmarkHandler( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KBookmarkHandler();
    /**
     * Writes a bookmark to the bookmark file. This works essentially
     * like the function above, but it takes a Smb4KBookmark object.
     */
    void addBookmark( Smb4KBookmark *bookmark );
    /**
     * This function writes a new list of bookmarks. The old list will be
     * deleted.
     */
    void writeBookmarkList( const QValueList<Smb4KBookmark *> &list );
    /**
     * Load the bookmarks.
     */
    void loadBookmarks();
    /**
     * Get the list of bookmarks.
     */
    const QValueList<Smb4KBookmark *> &getBookmarks() { return m_bookmarks; }

  signals:
    /**
     * Signal emitted when the list of bookmarks has been updated.
     */
    void bookmarksUpdated();
    /**
     * This signal is emitted, when an error occurred.
     *
     * @param error_code  The error code as defined in smb4kdefs.h.
     *
     * @param error_message The error message. Default is <code>QString::null</code>.
     */
    void error( int error_code, const QString &error_message = QString::null );

  private:
    /**
     * The KConfig object, that handles the bookmark file.
     */
    KConfig *m_config;
    /**
     * The list of bookmarks.
     */
    QValueList<Smb4KBookmark *> m_bookmarks;
    /**
     * Removes all bookmarks.
     */
    void clear();
};
#endif
