      real function rzero(r)
c     Avoid output formatting issues between IEEE positive/negative zero
      if (r .EQ. 0.0) r = +0.0
      rzero = r
      end

      subroutine qsolve(a, b, c, solution)
c     Solve quadratic equation Ax^2 + Bx + C = 0, returning 2 complex roots
      real a, b, c
      complex solution(2)
      real discrm, v, w
    
      v = rzero( -b / (2*a) )
      discrm = b*b - 4*a*c

      if ( discrm .LT. 0 ) then
        w = rzero( sqrt(-discrm) / (2*a))
        solution(1) = CMPLX(v, w)
        solution(2) = CMPLX(v, -w)
      else
        w = rzero(sqrt(discrm) / (2*a))
        solution(1) = CMPLX(v+w)
        solution(2) = CMPLX(v-w)
      end if

      end

      double complex function dcmult(a, b)
c     Multiply two double-precision complex nummgers
      double complex a, b
      dcmult = a * b
      if (dcmult .EQ. 0.0) dcmult = +0.0
      end

      complex function cmult(a, b)
c     Multiply two single-precision complex nummgers
      complex a, b
      cmult = a * b
      if (cmult .EQ. 0.0) cmult = +0.0
      end

      complex function fcadd(a, b)
c     Add two single-precision complex nummgers
      complex a, b
      fcadd = rzero(a + b)
      end

      subroutine ftnprint(message)
c     Simple echo, to exercise the C to FORTRAN path for strings
      character*(*) message
      print 10, message
   10 format(A)
      end
