
setup;

dims = [140, 107, 3];
nelems = int(prod(dims));

% Test 1:  compare gif_read() to fread() of raw binary
file = "logo.bin";
nbytes = fread(&im, UChar_Type, nelems, fopen(file, "rb"));
if (nbytes != nelems)
   error("Could not read $nelem bytes from $file, only $nbytes were read"$);

reshape(im, dims);
file = "logo.gif";
compare(im,  gif_read(file));

% Test 2: read from an opened file pointer
fp = fopen(file, "rb");
compare(im, gif_read(fp));

% Test 3: attempting to read non-existent frame should return NULL
im2 = gif_read(file, 2);
if (im2 != NULL)
   error("gif_read($file, 2) failed: should return NULL, file has 1 frame "$);

% Test 4: gif image with transparency (see doc/transp for outstanding issues)
% ToDo: create a list of transparent pixels & check it here OR do
%	rgb[0,0,0] = 255 (red only) and overlay & check results
file = "transparent.gif";
im = gif_read(file);
opaque = where(im[*,*,3] != 0);
transp = where(im[*,*,3] == 0);
if ("$opaque"$ != "Integer_Type[2364]" || "$transp"$ != "Integer_Type[32784]")
   error("Transparency information from $file not read correctly!"$);

% Test 5: reading a non-gif should fail
file = "logo.bin";
im = gif_read(file);
if (im != NULL)
   error("gif_read($file) should've returned NULL, but instead returned $im"$);

% Test 6: reading a corrupted gif should fail
file = "truncated.gif";
im = gif_read(file);
if (im != NULL)
   error("gif_read($file) should've returned NULL, but instead returned $im"$);
