
#ifndef GIFSICLE_EXTENSIONS

#define GIFSICLE_EXTENSIONS

#ifdef __cplusplus
extern "C" {
#endif

typedef struct Gif_RGBA Gif_RGBA;

struct Gif_RGBA
{
   uint8_t *pixels;
   uint16_t width;
   uint16_t height;
   int nchannels;	/* 1 = greyscale, 3 = RGB, 4 = RGB+alpha */
   int refcount;
   Gif_Colormap *cmap;
};

extern Gif_RGBA* 	Gif_NewRGBA(void);
extern void		Gif_DeleteRGBA(Gif_RGBA *gfr);
extern Gif_RGBA*	Gif_ImageToRGBA(Gif_Image *gfi, Gif_Colormap *cmap);
extern Gif_RGBA*	Gif_GetRGBA(Gif_Stream *gfs, int which);
extern Gif_Colormap*	Gif_GetGlobalColormap(Gif_Stream *gfs);
extern Gif_Image*	Gif_ImageFromRGBA(Gif_RGBA *gfr);
extern Gif_Image*	Gif_ImageFromRGBABuf(uint8_t rgba[], uint16_t w,
						uint16_t h, int nchannels);
extern void		gif_reflect(void *image,int bpp,int w,int h, int axes);
extern uint16_t		Gif_ImageGetDelay(Gif_Image *gfi);
extern void		Gif_ImageSetDelay(Gif_Image *gfi, uint16_t delay);
extern void		Gif_ImageRef(Gif_Image *gfi);

#ifdef __cplusplus
}
#endif

#endif
