%  SLgtk: S-Lang language bindings for GTK+ widget set
%
%  Copyright (c) 2003-2009 Massachusetts Institute of Technology
%  Copyright (C) 2002 Michael S. Noble <mnoble@cfa.harvard.edu>
%
%  This software was partially developed by the MIT Center for Space
%  Research under contract SV1-61010 from the Smithsonian Institution.
%  
%  Permission to use, copy, modify, distribute, and sell this software
%  and its documentation for any purpose is hereby granted without fee,
%  provided that the above copyright notice appear in all copies and
%  that both that copyright notice and this permission notice appear in
%  the supporting documentation, and that the name of the Massachusetts
%  Institute of Technology not be used in advertising or publicity
%  pertaining to distribution of the software without specific, written
%  prior permission.  The Massachusetts Institute of Technology makes
%  no representations about the suitability of this software for any
%  purpose.  It is provided "as is" without express or implied warranty.
%  
%  THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY DISCLAIMS ALL WARRANTIES
%  WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
%  MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE MASSACHUSETTS
%  INSTITUTE OF TECHNOLOGY BE LIABLE FOR ANY SPECIAL, INDIRECT OR
%  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
%  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
%  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
%  WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

require("vwhere");

private define print_result(vw)
{
   variable l = length(vw), section = min([l,20]);
   () = printf("vwhere() returned array of %d indices: ",l);
   if (l == section)
	() = printf("they are :\n");
   else
	() = printf("the first %d are :\n",section);

   _for (0, section - 1, 1) {
	l = ();
   	vmessage("%S",vw[l]);
   }
}

private define struct_dataset1(button)
{
   variable ds = struct {time, scatter2, PIE, CAKE, ICING};
   ds.time = [ 77, 7,   104, 51, 46, 23, 91, 41, 63,  55, 41, 65, 19, 37];
   ds.scatter2 = [ 24, 102, 88,  63, 86, 72, 37, 17, 87, 55, 49, 42,  31, 22];
   ds.PIE = [ PI/2 : PI/2. * (length(ds.time)+.5) : PI/2. ];
   ds.CAKE = sin(ds.PIE);
   ds.ICING = ds.PIE^2;
   print_result(vwhere(ds));
}

private define struct_dataset2(button)
{
   variable ds = struct { x, x_squared, ignorable_null, abs_x_div2, tooshort};
   variable size = getenv("VWHERE_TEST_ARRAY_SIZE");
   if (size != NULL)
      size = integer(size);
   else
      size = 100000;

   ds.x = [-size/2.0 : size/2.0];
   ds.x_squared = ds.x^2;
   ds.abs_x_div2 = abs(ds.x) / 2;
   ds.tooshort = [5:25:5];
   print_result(vwhere(ds));
}

private define array_dataset(button)
{
   print_result(vwhere([-99:150],[-99:150]^3));
}

private define refs_dataset(button)
{
   variable vec1 = [-50:50];
   variable vec2 = vec1^2;
   variable vec3 = 2.5*vec2;
   
   print_result(vwhere(&vec1, &vec2, &vec3));
}

private variable window = NULL;
define create_viswhere(test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (window, "Visual Where");
	gtk_container_set_border_width (window, 15);
	() = g_signal_connect (window,"destroy",&gtk_widget_destroyed,&window);

	variable align = gtk_alignment_new(0.5,0.5,0,0);
	gtk_container_add(window,align);

	variable vbox = gtk_vbox_new(FALSE,10);
	gtk_container_add(align,vbox);

	variable label = gtk_label_new(NULL);
	gtk_label_set_markup_with_mnemonic (label,
		"\nThis example demonstrates some of the\n"+
		"capabilities of SLgtk's <b><i>vwhere</i></b>, a visual\n"+
		"version of the S-Lang <b><i>where</i></b> function.\n"+
		"Note that some non-plottable types and \n"+
		"values are used, to show that they'll be\n"+
		"automatically culled prior to display.\n");
	gtk_box_pack_start(vbox,label,FALSE,FALSE,0);

	variable button = gtk_button_new_with_label("struct_dataset1");
	() = g_signal_connect(button,"clicked",&struct_dataset1);
	gtk_box_pack_start(vbox,button,FALSE,FALSE,0);

	button = gtk_button_new_with_label("configurable_struct");
	() = g_signal_connect(button,"clicked",&struct_dataset2);
	gtk_box_pack_start(vbox,button,FALSE,FALSE,0);

	button = gtk_button_new_with_label("array_dataset");
	() = g_signal_connect(button,"clicked",&array_dataset);
	gtk_box_pack_start(vbox,button,FALSE,FALSE,0);

	button = gtk_button_new_with_label("refs");
	() = g_signal_connect(button,"clicked",&refs_dataset);
	gtk_box_pack_start(vbox,button,FALSE,FALSE,0);

	test.lower = generic_close_button(vbox,window);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
