static variable window = NULL;
   
static define reformat_value (scale, value, data)
{
  return sprintf ("-->%0.*g<--",gtk_scale_get_digits (scale), value);
}

define create_range (test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

	() = g_signal_connect (window, "destroy",
			  &gtk_widget_destroyed,
			  &window);

	gtk_window_set_title (window, "range controls");
	gtk_container_set_border_width ( window, 0);

	variable box1 = gtk_vbox_new (FALSE, 0);
	gtk_container_add ( window, box1);

	variable box2 = gtk_vbox_new (FALSE, 10);
	gtk_container_set_border_width ( box2, 10);
	gtk_box_pack_start (box1, box2, TRUE, TRUE, 0);

	variable adj = gtk_adjustment_new(0.0, 0.0, 101.0, 0.1, 1.0, 1.0);

	variable scale = gtk_hscale_new (adj);
	gtk_widget_set_usize (scale, 150, -1);
	gtk_range_set_update_policy (scale, GTK_UPDATE_DELAYED);
	gtk_scale_set_digits (scale, 1);
	gtk_scale_set_draw_value (scale, TRUE);
	gtk_box_pack_start (box2, scale, TRUE, TRUE, 0);

	variable scrollbar = gtk_hscrollbar_new (adj);
	gtk_range_set_update_policy (scrollbar, 
				   GTK_UPDATE_CONTINUOUS);
	gtk_box_pack_start (box2, scrollbar, TRUE, TRUE, 0);

	scale = gtk_hscale_new (adj);
	gtk_scale_set_draw_value (scale, TRUE);
	() = g_signal_connect (scale, "format_value", &reformat_value, NULL);
	gtk_box_pack_start (box2, scale, TRUE, TRUE, 0);
      
	variable hbox = gtk_hbox_new (FALSE, 0);

	scale = gtk_vscale_new (adj);
	gtk_widget_set_usize (scale, -1, 200);
	gtk_scale_set_digits (scale, 2);
	gtk_scale_set_draw_value (scale, TRUE);
	gtk_box_pack_start (hbox, scale, TRUE, TRUE, 0);

	scale = gtk_vscale_new (adj);
	gtk_widget_set_usize (scale, -1, 200);
	gtk_scale_set_digits (scale, 2);
	gtk_scale_set_draw_value (scale, TRUE);
	gtk_range_set_inverted (scale, TRUE);
	gtk_box_pack_start (hbox, scale, TRUE, TRUE, 0);

	scale = gtk_vscale_new (adj);
	gtk_scale_set_draw_value (scale, TRUE);
	() = g_signal_connect (scale, "format_value", &reformat_value, NULL);
	gtk_box_pack_start (hbox, scale, TRUE, TRUE, 0);

	gtk_box_pack_start (box2, hbox, TRUE, TRUE, 0);
	test.lower = generic_close_button(box1,window);
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
