
static variable window = NULL;

static define done_configure(event, widget)
{
   g_object_set_data(widget, "timer", NULL);
   gtk_widget_queue_draw(widget);
   return FALSE;
}

static define configure_cb(window, event, ctx)
{
   variable timer = g_object_get_data(ctx.widget, "timer");
   if (timer != NULL)
      gtk_timeout_remove(timer);

   timer = gtk_timeout_add(120, &done_configure, event, ctx.widget);
   g_object_set_data(ctx.widget, "timer", timer);
   return FALSE;
}

static define expose_cb(widget, event, ctx)
{
   variable x = 0, y = 0, w, h, root_x, root_y;

   gdk_drawable_get_size(ctx.drawable, &w, &h);
   () = gdk_window_get_origin(ctx.drawable, &root_x, &root_y);

   if (root_x < 0) x -= root_x;
   if (root_y < 0) y -= root_y;
   gdk_draw_image(ctx.drawable, ctx.gc, ctx.rimage, root_x, root_y, x, y, w, h);

   return TRUE;
}

static define realize_cb(widget, ctx)
{
   ctx.drawable = gtk_widget_get_window(widget);
   ctx.gc = gdk_gc_new(ctx.drawable);
}

define create_transparency(test)
{

   if (window == NULL) {

	variable rwin = gdk_get_default_root_window();
	variable rw = gdk_screen_width(), rh = gdk_screen_height();

	variable context = struct { rimage, widget, drawable, gc};
	context.rimage = gdk_drawable_get_image(rwin, 0, 0, rw, rh);
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(window, "Transparency Example");
	gtk_window_set_default_size(window, 350, 250);
	() = g_signal_connect(window,"destroy",&gtk_widget_destroyed,&window);
	() = g_signal_connect(window,"configure-event",&configure_cb, context);

	variable vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(window,vbox);

	variable rhbox = gtk_hbox_new(FALSE,0);
	gtk_container_add(vbox,rhbox);

	context.widget = gtk_drawing_area_new();
	gtk_container_add(rhbox, context.widget);
	() = g_signal_connect(context.widget,"realize",&realize_cb,context);
	() = g_signal_connect(context.widget,"expose-event",&expose_cb,context);

	variable separator = gtk_hseparator_new();
	gtk_box_pack_start (vbox, separator, FALSE, TRUE, 0);

	variable hbox = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(vbox,hbox,FALSE,FALSE,5);

	variable label = gtk_label_new("Resize or move this window to see "+
					"more of your desktop within it.");
	gtk_box_pack_start(hbox,label,FALSE,FALSE,5);


	variable button = gtk_button_new_with_label("    Close    ");
	() = g_signal_connect_swapped(button, "clicked",
					&gtk_widget_destroy,window);
	gtk_box_pack_end(hbox,button,FALSE,FALSE,5);
	test.lower = button;
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
