
#include <stdio.h>
#include "csubs.h"

extern void qsolve_(float *a, float *b, float *c, complex *solution);
extern void dcmult_(doublecomplex *ret, doublecomplex *a, doublecomplex *b);
extern void cmult_(complex *ret, complex *a, complex *b);
extern void ftnprint_(char *message, long len);

int main()
{
   float a, b, c;
   complex cproduct, csum, soln[2];
   doublecomplex dsoln[2];
   doublecomplex dproduct;

   while (scanf("%f,%f,%f", &a, &b, &c) == 3) {

	qsolve_(&a, &b, &c, soln);
	printf("Coefficients: (%8.4f, %8.4f, %8.4f)\n",a,b,c);
	printf("Root #1     : (%8.4f, %8.4f i)\n", soln[0].r, soln[0].i);
	printf("Root #2     : (%8.4f, %8.4f i)\n", soln[1].r, soln[1].i);

	dsoln[0].r = soln[0].r;
	dsoln[0].i = soln[0].i;
	dsoln[1].r = soln[1].r;
	dsoln[1].i = soln[1].i;

	dcmult_(&dproduct, dsoln, dsoln+1);
	printf("D-Multiplied: (%8.4f, %8.4f i)\n",dproduct.r, dproduct.i);

#if 0
	This is disabled until gfortran compability is fully establshed,
	since -ff2c is not a sufficient solution.
	cmult_(&cproduct, soln, soln+1);
#else
	cproduct.r = (real)dproduct.r; cproduct.i = (real)cproduct.i;
#endif
	printf("C-Multiplied: (%8.4f, %8.4f i)\n",cproduct.r, cproduct.i);

	c_cadd(soln[0], soln[1], &csum);
	printf("C-Added     : (%8.4f, %8.4f i)\n\n",csum.r, csum.i);
   }

   ftnprint_("Done ...", 8);

   return 0;
}
