#include "petscsys.h"
#include "petscfix.h"
/* dense.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepceps.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdensenhep_ EPSDENSENHEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdensenhep_ epsdensenhep
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdensegnhep_ EPSDENSEGNHEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdensegnhep_ epsdensegnhep
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdensehep_ EPSDENSEHEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdensehep_ epsdensehep
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdenseghep_ EPSDENSEGHEP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdenseghep_ epsdenseghep
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdensehessenberg_ EPSDENSEHESSENBERG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdensehessenberg_ epsdensehessenberg
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdenseschur_ EPSDENSESCHUR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdenseschur_ epsdenseschur
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssortdenseschur_ EPSSORTDENSESCHUR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssortdenseschur_ epssortdenseschur
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssortdenseschurgeneralized_ EPSSORTDENSESCHURGENERALIZED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssortdenseschurgeneralized_ epssortdenseschurgeneralized
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsdensetridiagonal_ EPSDENSETRIDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsdensetridiagonal_ epsdensetridiagonal
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  epsdensenhep_(PetscInt *n_,PetscScalar *A,PetscScalar *w,PetscScalar *wi,PetscScalar *V,PetscScalar *W, int *__ierr ){
*__ierr = EPSDenseNHEP(*n_,A,w,wi,V,W);
}
void PETSC_STDCALL  epsdensegnhep_(PetscInt *n_,PetscScalar *A,PetscScalar *B,PetscScalar *w,PetscScalar *wi,PetscScalar *V,PetscScalar *W, int *__ierr ){
*__ierr = EPSDenseGNHEP(*n_,A,B,w,wi,V,W);
}
void PETSC_STDCALL  epsdensehep_(PetscInt *n_,PetscScalar *A,PetscInt *lda_,PetscReal *w,PetscScalar *V, int *__ierr ){
*__ierr = EPSDenseHEP(*n_,A,*lda_,w,V);
}
void PETSC_STDCALL  epsdenseghep_(PetscInt *n_,PetscScalar *A,PetscScalar *B,PetscReal *w,PetscScalar *V, int *__ierr ){
*__ierr = EPSDenseGHEP(*n_,A,B,w,V);
}
void PETSC_STDCALL  epsdensehessenberg_(PetscInt *n_,PetscInt *k,PetscScalar *A,PetscInt *lda_,PetscScalar *Q, int *__ierr ){
*__ierr = EPSDenseHessenberg(*n_,*k,A,*lda_,Q);
}
void PETSC_STDCALL  epsdenseschur_(PetscInt *n_,PetscInt *k,PetscScalar *H,PetscInt *ldh_,PetscScalar *Z,PetscScalar *wr,PetscScalar *wi, int *__ierr ){
*__ierr = EPSDenseSchur(*n_,*k,H,*ldh_,Z,wr,wi);
}
void PETSC_STDCALL  epssortdenseschur_(EPS *eps,PetscInt *n_,PetscInt *k,PetscScalar *T,PetscInt *ldt_,PetscScalar *Q,PetscScalar *wr,PetscScalar *wi, int *__ierr ){
*__ierr = EPSSortDenseSchur(*eps,*n_,*k,T,*ldt_,Q,wr,wi);
}
void PETSC_STDCALL  epssortdenseschurgeneralized_(EPS *eps,PetscInt *n_,PetscInt *k0,PetscInt *k1,PetscScalar *T,PetscScalar *S,PetscInt *ldt_,PetscScalar *Q,PetscScalar *Z,PetscScalar *wr,PetscScalar *wi, int *__ierr ){
*__ierr = EPSSortDenseSchurGeneralized(*eps,*n_,*k0,*k1,T,S,*ldt_,Q,Z,wr,wi);
}
void PETSC_STDCALL  epsdensetridiagonal_(PetscInt *n_,PetscReal *D,PetscReal *E,PetscReal *w,PetscScalar *V, int *__ierr ){
*__ierr = EPSDenseTridiagonal(*n_,D,E,w,V);
}
#if defined(__cplusplus)
}
#endif
