#include "types.h"
#include "emul.h"

#include "skyeye_config.h"

extern MIPS_State *mstate;

UInt32
mips_io_read_byte(UInt32 addr)
{
	if (skyeye_config.mach->mach_io_read_byte)
		return skyeye_config.mach->mach_io_read_byte(mstate, addr);
	else
		return 0;
}

UInt32
mips_io_read_halfword(UInt32 addr)
{	
	if (skyeye_config.mach->mach_io_read_halfword)
		return skyeye_config.mach->mach_io_read_halfword(mstate, addr);
	else
		return 0;
}

UInt32
mips_io_read_word(UInt32 addr)
{
	
	if (skyeye_config.mach->mach_io_read_word)
		return skyeye_config.mach->mach_io_read_word(mstate, addr);
	else
		return 0;
}

UInt64
mips_io_read_doubleword(UInt32 addr)
{
	return 0;
}

void
mips_io_write_byte(UInt32 addr, UInt32 data)
{
	
	if (skyeye_config.mach->mach_io_write_byte)
		skyeye_config.mach->mach_io_write_byte(mstate, addr, data);
}

void
mips_io_write_halfword(UInt32 addr, UInt32 data)
{
	
	if (skyeye_config.mach->mach_io_write_halfword)
		skyeye_config.mach->mach_io_write_halfword(mstate, addr, data);
}

void
mips_io_write_word(UInt32 addr, UInt32 data)
{
	
	if (skyeye_config.mach->mach_io_write_word)
		skyeye_config.mach->mach_io_write_word(mstate, addr, data);
}

void
mips_io_write_doubleword(UInt32 addr, UInt32 data)
{

}
