/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test for actions.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestactions.h"
#include "skgmainpanel.h"
#include "skgboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgtestmacro.h"

void SKGTESTActions::Test()
{
    // Initialize document
    SKGDocumentBank doc;

    // Create main panel
    SKGMainPanel mainpanel(nullptr, &doc, QStringList());
    mainpanel.show();

    QVERIFY2(!doc.load(SKGTest::getTestPath(QStringLiteral("IN")) % "/advice.skg"), "Load document failed");

    // Scenario
    QStringList actionsToExecute;
    actionsToExecute
    // Reinitialize document
            << QStringLiteral("tab_closeall") << QStringLiteral("fullscreen") << QStringLiteral("fullscreen") << QStringLiteral("fullscreen") << QStringLiteral("edit_undolastsave") << QStringLiteral("view_unlock") << QStringLiteral("view_unlock") << QStringLiteral("options_show_menubar") << QStringLiteral("options_show_menubar")
            // Bank page
            << QStringLiteral("page_Skrooge bank plugin") << QStringLiteral("enable_editor") << QStringLiteral("edit_select_all") << QStringLiteral("edit_copy") << QStringLiteral("edit_switch_highlight") << QStringLiteral("edit_select_all") << QStringLiteral("edit_delete")
            // Undo
            << QStringLiteral("edit_undo") << QStringLiteral("edit_redo") << QStringLiteral("edit_undolastsave") << QStringLiteral("edit_clear_history")
            // Clean
            << QStringLiteral("edit_select_all") << QStringLiteral("open_report") << QStringLiteral("edit_find")
            << QStringLiteral("page_Skrooge bank plugin") << QStringLiteral("edit_select_all") << QStringLiteral("edit_reconciliate")
            << QStringLiteral("page_Skrooge bank plugin") << QStringLiteral("edit_select_all") << QStringLiteral("edit_find")

            // Operation
            << QStringLiteral("page_Skrooge operation plugin") << QStringLiteral("enable_editor") << QStringLiteral("fast_edition") << QStringLiteral("edit_select_all") << QStringLiteral("edit_switch_highlight") << QStringLiteral("edit_point_selected_operation")
            << QStringLiteral("merge_sub_operations")
            // Too long << "edit_select_all" << "edit_duplicate_operation"
            << QStringLiteral("edit_select_all") << QStringLiteral("edit_group_operation") << QStringLiteral("merge_imported_operation")
            << QStringLiteral("edit_select_all") << QStringLiteral("open_report")
            << QStringLiteral("page_Skrooge operation plugin") << QStringLiteral("edit_select_all") << QStringLiteral("edit_find")

            // Category
            << QStringLiteral("page_Skrooge categories plugin") << QStringLiteral("edit_expandall") << QStringLiteral("edit_collapseal")
            << QStringLiteral("edit_select_all") << QStringLiteral("open_report")
            << QStringLiteral("page_Skrooge categories plugin") << QStringLiteral("edit_select_all") << QStringLiteral("edit_find")

            // Search page
            << QStringLiteral("page_Skrooge search plugin") << QStringLiteral("edit_select_all")
            << QStringLiteral("execute_all") << QStringLiteral("execute_imported") << QStringLiteral("execute_not_validated")
            << QStringLiteral("open_report")

            // All other pages
            << QStringLiteral("page_Dashboard plugin") << QStringLiteral("500")
            << QStringLiteral("page_Skrooge budget plugin") << QStringLiteral("tool_process_budget_rules") << QStringLiteral("edit_select_all") << QStringLiteral("open_report")
            << QStringLiteral("page_Skrooge budget plugin") << QStringLiteral("edit_select_all") << QStringLiteral("edit_find")
            << QStringLiteral("page_Skrooge calculator plugin")
            << QStringLiteral("page_Skrooge payee plugin") << QStringLiteral("edit_select_all") << QStringLiteral("open_report")
            << QStringLiteral("page_Skrooge payee plugin") << QStringLiteral("edit_select_all") << QStringLiteral("edit_find")
            << QStringLiteral("page_Skrooge report plugin")
            << QStringLiteral("page_Skrooge scheduled plugin") << QStringLiteral("edit_select_all") << QStringLiteral("open_report")
            << QStringLiteral("page_Skrooge scheduled plugin") << QStringLiteral("edit_select_all") << QStringLiteral("edit_find")
            << QStringLiteral("page_Skrooge tracker plugin") << QStringLiteral("edit_select_all") << QStringLiteral("open_report")
            << QStringLiteral("page_Skrooge tracker plugin") << QStringLiteral("edit_select_all") << QStringLiteral("edit_find")
            << QStringLiteral("page_Skrooge unit plugin") << QStringLiteral("edit_select_all") << QStringLiteral("open_report")
            << QStringLiteral("page_Skrooge unit plugin") << QStringLiteral("edit_select_all") << QStringLiteral("edit_find")

            // Go
            << QStringLiteral("page_Monthly plugin") << QStringLiteral("go_previous") << QStringLiteral("go_next") << QStringLiteral("go_home") << QStringLiteral("new_tab")

            // imports
            << QStringLiteral("import") << QStringLiteral("import_backends") << QStringLiteral("import_standard_bookmarks") << QStringLiteral("import_standard_categories")

            // Processing
            << QStringLiteral("clean_align_comment") << QStringLiteral("clean_delete_unused_categories") << QStringLiteral("clean_delete_unused_payees") << QStringLiteral("clean_delete_unused_units") << QStringLiteral("clean_remove_group_with_one_operation")
            << QStringLiteral("process_banks") << QStringLiteral("process_foundtransfer") << QStringLiteral("process_validate") << QStringLiteral("processing") << QStringLiteral("switch_validation_imported_operation")

            // Views
            << QStringLiteral("view_bookmarks") << QStringLiteral("view_context") << QStringLiteral("view_contextmenu") << QStringLiteral("view_lock") << QStringLiteral("view_menu") << QStringLiteral("view_open_duplicates") << QStringLiteral("view_open_highlight")
            << QStringLiteral("view_open_last_modified") << QStringLiteral("view_open_not_validated") << QStringLiteral("view_open_operation_in_group_of_one") << QStringLiteral("view_open_operation_with_comment_not_aligned")
            << QStringLiteral("view_open_operation_without_category") << QStringLiteral("view_open_operation_without_mode") << QStringLiteral("view_open_operation_without_payee") << QStringLiteral("view_open_suboperations")
            << QStringLiteral("view_open_transfers_without_category") << QStringLiteral("view_open_transfers_without_payee") << QStringLiteral("view_open_very_old_operations") << QStringLiteral("view_properties") << QStringLiteral("view_transactions")
            // Close
            << QStringLiteral("tab_close") << QStringLiteral("tab_closeallother") << QStringLiteral("tab_closeall")
            // Tabs
            << QStringLiteral("tab_reopenlastclosed") << QStringLiteral("tab_resetdefaultstate") << QStringLiteral("tab_savedefaultstate") << QStringLiteral("tab_switchpin") << QStringLiteral("tab_overwritebookmark")

            // File
            << QStringLiteral("file_save") << QStringLiteral("file_new");

    // Dump actions
    QMap< QString, QPointer<QAction> > actions = mainpanel.getGlobalActions();
    QStringList keys = actions.keys();
    for (const auto& key : qAsConst(keys)) {
        if (!actionsToExecute.contains(key)) {
            SKGTRACE << "  [" << key << "]" << endl;
        }
    }

    // Trigger actions
    for (const auto& key : qAsConst(actionsToExecute)) {
        if (key == QStringLiteral("edit_select_all")) {
            SKGTRACE << "      Wait" << endl;
            QTest::qWait(10);
        }
        SKGTRACE << QDateTime::currentDateTime().toString(QStringLiteral("yyyy-MM-dd hh:mm:ss")) << "  [" << key << "]: ";
        QAction* act = mainpanel.getGlobalAction(key);
        if (act) {
            act->trigger();
            SKGTRACESUITE << "DONE" << endl;
        } else {
            SKGTRACESUITE << "UNKNOWN" << endl;
        }

        if (key == QStringLiteral("edit_select_all")) {
            SKGTabPage* page = mainpanel.currentPage();
            if (page) {
                SKGTRACE << "      Current page:" << page->objectName() << endl;
            }
            SKGTRACE << "      Nb objects selected:" << mainpanel.getNbSelectedObjects() << endl;
        }
    }
}

QTEST_MAIN(SKGTESTActions)

