/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A zoom selector.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgzoomselector.h"
#include "skglineedit.h"

#include <qtextstream.h>

SKGZoomSelector::SKGZoomSelector(QWidget* parent)
    : QWidget(parent), m_resetValue(0)
{
    ui.setupUi(this);

    //Set icons
    ui.kZoomIn->setIcon(KIcon("zoom-in"));
    ui.kZoomOut->setIcon(KIcon("zoom-out"));
    ui.kZoomOriginal->setIcon(KIcon("zoom-original"));

    //Init timer
    m_timer.setSingleShot(true);
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(onZoomChanged()), Qt::QueuedConnection);
}

SKGZoomSelector::~SKGZoomSelector()
{
}

void SKGZoomSelector::setValue(int iValue, bool iEmitEvent)
{
    bool previous = ui.kZoomSlider->blockSignals(!iEmitEvent);
    ui.kZoomSlider->setValue(iValue);
    ui.kZoomSlider->blockSignals(previous);
}

int SKGZoomSelector::value() const
{
    return ui.kZoomSlider->value();
}

int SKGZoomSelector::resetValue() const
{
    return m_resetValue;
}

void SKGZoomSelector::setResetValue(int iValue)
{
    m_resetValue = iValue;
}

void SKGZoomSelector::zoomIn()
{
    ui.kZoomSlider->setValue(ui.kZoomSlider->value() + 1);
}

void SKGZoomSelector::zoomOut()
{
    ui.kZoomSlider->setValue(ui.kZoomSlider->value() - 1);
}

void SKGZoomSelector::initializeZoom()
{
    ui.kZoomSlider->setValue(m_resetValue);
}

void SKGZoomSelector::onZoomChangedDelayed()
{
    m_timer.start(300);
}

void SKGZoomSelector::onZoomChanged()
{
    int val = ui.kZoomSlider->value();
    if (ui.kZoomIn) ui.kZoomIn->setEnabled(val < 10);
    if (ui.kZoomOut) ui.kZoomOut->setEnabled(val > -10);
    if (ui.kZoomOriginal) ui.kZoomOriginal->setChecked(val == 0);

    Q_EMIT changed(val);
}
#include "skgzoomselector.moc"

