/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for interest computation.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skginterestboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgaccountobject.h"
#include "skgunitobject.h"
#include "skgmainpanel.h"

#include <QDomDocument>

SKGInterestBoardWidget::SKGInterestBoardWidget(SKGDocument* iDocument)
    : SKGWidget(iDocument)
{
    SKGTRACEIN(10, "SKGInterestBoardWidget::SKGInterestBoardWidget");

    ui.setupUi(this);

    //Refresh
    connect((const QObject*) getDocument(), SIGNAL(tableModified(QString,int)), this, SLOT(dataModified(QString,int)), Qt::QueuedConnection);
    connect(ui.kLabel, SIGNAL(linkActivated(QString)), SKGMainPanel::getMainPanel(), SLOT(openPage(QString)));
}

SKGInterestBoardWidget::~SKGInterestBoardWidget()
{
    SKGTRACEIN(10, "SKGInterestBoardWidget::~SKGInterestBoardWidget");
}

QString SKGInterestBoardWidget::getState()
{
    return "";
}

void SKGInterestBoardWidget::setState(const QString& iState)
{
    Q_UNUSED(iState);
    dataModified("", 0);
}

QString SKGInterestBoardWidget::getDefaultStateAttribute()
{
    return "SKGINTERESTBOARD_DEFAULT_PARAMETERS";
}

void SKGInterestBoardWidget::dataModified(const QString& iTableName, int iIdTransaction)
{
    SKGTRACEIN(10, "SKGInterestBoardWidget::dataModified");
    Q_UNUSED(iIdTransaction);

    if (iTableName == "v_account" || iTableName == "interest" || iTableName.isEmpty()) {
        SKGDocumentBank* doc = qobject_cast<SKGDocumentBank*>(getDocument());
        if (doc) {
            SKGServices::SKGUnitInfo primary = doc->getPrimaryUnit();

            //Build display
            QString html = "<html><body>";
            SKGObjectBase::SKGListSKGObjectBase objs;
            SKGError err = doc->getObjects("v_account", "t_close='N' AND EXISTS(select 1 from interest where interest.rd_account_id=v_account.id) ORDER BY t_name", objs);
            if (!err) {
                int nb = objs.count();
                if (nb) {
                    html += "<table>";
                    double sum = 0;
                    for (int i = 0; i < nb; ++i) {
                        SKGAccountObject obj = objs.at(i);
                        html += QString("<tr><td><a href=\"skg://Skrooge_calculator_plugin/?currentPage=0&account=" % KUrl::encode_string(obj.getName()) % "\">") % SKGServices::stringToHtml(obj.getName()) % "</a></td><td align=\"right\">";

                        QList<SKGAccountObject::SKGInterestItem> oInterestList;
                        double oInterests = 0;
                        obj.getInterestItems(oInterestList, oInterests);
                        sum += oInterests;

                        html += doc->formatMoney(oInterests, primary);
                        html += "</td></tr>";
                    }
                    html += "<tr><td><b>" % SKGServices::stringToHtml(i18nc("Noun, the numerical total of a sum of values", "Total")) % "</b></td>"
                            "<td align=\"right\"><b>" % doc->formatMoney(sum, primary) % "</b></td>"
                            "</tr>";
                    html += "</table>";
                } else {
                    html += i18nc("A Message for the user about financial interests", "No interest defined for accounts<br>on the <a href=\"skg://Skrooge_calculator_plugin/?currentPage=0\">\"Simulation\"</a> page.");
                }
                html += "</body></html>";
                ui.kLabel->setText(html);
            }

            //No widget if no account
            bool exist = false;
            getDocument()->existObjects("account", "", exist);
            if (parentWidget()) setVisible(exist);
        }
    }
}

#include "skginterestboardwidget.moc"
