/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGREPORTBANK_H
#define SKGREPORTBANK_H
/** @file
 * A report class for bank document
*
* @author Stephane MANKOWSKI
*/
#include "skgerror.h"
#include "skgreport.h"
#include "skgbankmodeler_export.h"

#include <QVariant>

class SKGDocument;
/**
 * A report class for bank document
 */
class SKGBANKMODELER_EXPORT SKGReportBank : public SKGReport
{
    Q_OBJECT
    /**
     * The budget table
     */
    Q_PROPERTY(QVariantList budget_table READ getBudgetTable)

    /**
     * The unit table
     */
    Q_PROPERTY(QVariantList unit_table READ getUnitTable)

    /**
     * The account table
     */
    Q_PROPERTY(QVariantList account_table READ getAccountTable)

    /**
     * The main categories of the month
     */
    Q_PROPERTY(QVariantList categories_month READ getMainCategoriesMonth)

    /**
     * The main categories of the previous month
     */
    Q_PROPERTY(QVariantList categories_previous_month READ getMainCategoriesPreviousMonth)

    /**
     * The income versus expenditure
     */
    Q_PROPERTY(QVariantList income_vs_expenditure READ getIncomeVsExpenditure)

    /**
     * The main categories variations
     */
    Q_PROPERTY(QStringList categories_variations READ get5MainCategoriesVariation)

    /**
     * The main nls strings
     */
    Q_PROPERTY(QStringList titles READ getTitles)

public:
    /**
     * Default Constructor
     */
    SKGReportBank(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGReportBank();

    /**
     * Get the budget table
     * @return the budget table
     */
    virtual QVariantList getBudgetTable();

    /**
     * Get the unit table
     * @return the unit table
     */
    virtual QVariantList getUnitTable();

    /**
     * Get the account table
     * @return the account table
     */
    virtual QVariantList getAccountTable();

    /**
     * Get the main categories of the month
     * @return the main categories of the month
     */
    virtual QVariantList getMainCategoriesMonth();

    /**
     * Get the main categories of the previous month
     * @return the main categories of the previous month
     */
    virtual QVariantList getMainCategoriesPreviousMonth();

    /**
     * Get the main categories variations
     * @return the main categories variations
     */
    virtual QStringList get5MainCategoriesVariation();

    /**
     * Get the main titles
     * @return the main titles
     */
    virtual QStringList getTitles();

    /**
     * Get the income versus expenditure
     * @return the income versus expenditure
     */
    virtual QVariantList getIncomeVsExpenditure();

    /**
     * Get advices
     * @return the advices
     */
    virtual QVariant getAdvices();

protected:
    /**
     * Enrich the grantlee mapping
     * @param iMapping the mapping
     */
    virtual void addItemsInMapping(QVariantHash& iMapping);

private:
    Q_DISABLE_COPY(SKGReportBank);
};

#endif // SKGREPORTBANK_H
