/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#ifndef ADVICESKROOGOID_H
#define ADVICESKROOGOID_H
/** @file
* This file is Plasma Applet for Advice Skroogoid
*
* @author Siddharth SHARMA
*/
#include <Plasma/PopupApplet>
#include <Plasma/Label>
#include <Plasma/ToolButton>
#include "skgdocumentbank.h"
#include <qgraphicslinearlayout.h>
#include <QFrame>
#include <Plasma/Frame>

class QGraphicsLinearLayout;
class QGraphicsGridLayout;
/**
 * Class AdviceSkroogoid
 */
class AdviceSkroogoid : public Plasma::Applet
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    AdviceSkroogoid(QObject* parent, const QVariantList& args);

    /**
     * Reimplemented from Plasma::Applet
     */
    virtual void init();

    /**
    * Default Destructor
    */
    ~AdviceSkroogoid();


public Q_SLOTS:

    /**
     * Reimplemented from Plasma::Applet
     */
    void dataUpdated(const QString& sourceName, const Plasma::DataEngine::Data& engineData);

private Q_SLOTS:

    /**
     * Add an advice line
     */
    void addAdviceLine(const QString uuid);

private:
    /**
     * The current Skrooge document
     */
    SKGDocumentBank* doc;

    /**
     * The QHash storing data fetched in the dataengine
     */
    QHash<QString, QVariantList> listData;

    /**
     * The applet layout
     */
    QGraphicsLinearLayout* widgetLayout;

    /**
     * A QHash to store Layouts for grouping
     * advices per priority type
     */
    QHash<QString, Plasma::Frame*> priorityGroups;

};

/**
 * For exporting skroogoid as a registered Plasma Applet
 */
K_EXPORT_PLASMA_APPLET(adviceskroogoid, AdviceSkroogoid)

#endif
