/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgscheduledboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgrecurrentoperationobject.h"
#include "skgmainpanel.h"

#include <QDomDocument>

SKGScheduledBoardWidget::SKGScheduledBoardWidget(SKGDocument* iDocument)
    : SKGWidget(iDocument)
{
    SKGTRACEIN(10, "SKGScheduledBoardWidget::SKGScheduledBoardWidget");

    ui.setupUi(this);

    //Refresh
    connect((const QObject*) getDocument(), SIGNAL(tableModified(QString,int)), this, SLOT(dataModified(QString,int)), Qt::QueuedConnection);
}

SKGScheduledBoardWidget::~SKGScheduledBoardWidget()
{
    SKGTRACEIN(10, "SKGScheduledBoardWidget::~SKGScheduledBoardWidget");

}

QString SKGScheduledBoardWidget::getState()
{
    return "";
}

void SKGScheduledBoardWidget::setState(const QString& iState)
{
    Q_UNUSED(iState);
    dataModified("", 0);
}

void SKGScheduledBoardWidget::dataModified(const QString& iTableName, int iIdTransaction)
{
    SKGTRACEIN(10, "SKGScheduledBoardWidget::dataModified");
    Q_UNUSED(iIdTransaction);

    if (iTableName == "v_recurrentoperation_display" || iTableName.isEmpty()) {
        SKGObjectBase::SKGListSKGObjectBase objs;
        SKGError err = getDocument()->getObjects("v_recurrentoperation_display", "1=1 ORDER BY d_date LIMIT 5", objs);
        if (!err) {
            QString html = "<html><body>";
            int nb = objs.count();
            if (nb) {
                for (int i = 0; i < nb; ++i) {
                    SKGRecurrentOperationObject obj = objs.at(i);

                    bool bold = false;
                    if (obj.isWarnEnabled() &&  QDate::currentDate() >= obj.getDate().addDays(-obj.getWarnDays())) bold = true;

                    if (bold) html += "<b>";
                    html += SKGServices::stringToHtml(obj.getDisplayName());
                    if (bold) html += "</b>";
                    html += "<br>";
                }
            } else {
                html += i18nc("Message", "No operation scheduled<br>on the <a href=\"___\">\"Operations\"</a> page.");
            }
            html += "</body></html>";
            ui.kLabel->setText(html);
        }

        //No widget if no account
        bool exist = false;
        getDocument()->existObjects("account", "", exist);
        if (parentWidget()) setVisible(exist);
    }
}

void SKGScheduledBoardWidget::onOpen(const QString& iLink)
{
    Q_UNUSED(iLink);
    //Call operation plugin
    QDomDocument doc("SKGML");
    doc.setContent(getDocument()->getParameter("SKGOPERATION_DEFAULT_PARAMETERS"));
    SKGMainPanel::getMainPanel()->openPage(SKGMainPanel::getMainPanel()->getPluginByName("Skrooge operation plugin"), -1, doc.toString());
}

#include "skgscheduledboardwidget.moc"
