/*
    Copyright (C) 2011  Guillaume DE BURE <guillaume.debure@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef INCOMEEXPENDITUREWIDGET_H
#define INCOMEEXPENDITUREWIDGET_H

#include <Plasma/Applet>
#include <Plasma/Label>
#include <QGraphicsLinearLayout>
#include <Plasma/Frame>
#include <skgservices.h>


class QGraphicsLinearLayout;
/**
 * Class ScheduledOperationSkroogoid
 */
class IncomeExpenditureWidget : public Plasma::Applet
{
    Q_OBJECT

public:
    /**
     * Standard constructor
     */
    IncomeExpenditureWidget(QObject* parent, const QVariantList& args);

    /**
     * Default destructor
     */
    virtual ~IncomeExpenditureWidget();

    /**
     * Reimplemented from Plasma::Applet
     */
    virtual void init();


private Q_SLOTS:
    /**
     * Fetch data from the specified source
     */
    void dataUpdated(const QString& sourceName, const Plasma::DataEngine::Data& engineData);


private:
    /**
     * The primary unit defined for the document
     */
    SKGServices::SKGUnitInfo primary;

    QGraphicsLinearLayout* widgetLayout;



};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(plasma_widget_incomeexpenditure, IncomeExpenditureWidget)

#endif // INCOMEEXPENDITUREWIDGET_H
