/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Alarm Skroogoid
*
* @author Siddharth SHARMA
*/
#include "alarmskroogoid.h"

#include "skgdocumentbank.h"
#include "skgservices.h"
#include "skgmainpanel.h"
#include "skgruleobject.h"

#include <kcolorscheme.h>

#include <QGraphicsLinearLayout>
#include <QProgressBar>
#include <QGraphicsProxyWidget>

AlarmSkroogoid::AlarmSkroogoid(QObject* parent, const QVariantList& args)
    : Plasma::PopupApplet(parent, args)
{

    setAspectRatioMode(Plasma::IgnoreAspectRatio);
    resize(300, 300);

    displayLabel = new Plasma::Label();
    gl_layout = new QGraphicsLinearLayout();
    setLayout(gl_layout);
    check = new Plasma::CheckBox();
    check->setText("Alarms");

    SKGMainPanel* panel = SKGMainPanel::getMainPanel();
    SKGDocumentBank* doc = qobject_cast<SKGDocumentBank*>(panel->getDocument());
    if (doc) {

        SKGServices::SKGUnitInfo primary = doc->getPrimaryUnit();
        SKGServices::SKGUnitInfo secondary = doc->getSecondaryUnit();
        SKGObjectBase::SKGListSKGObjectBase rules;
        SKGError err = doc->getObjects("v_rule", "t_bookmarked='Y' AND t_action_type='A' ORDER BY i_ORDER", rules);
        int nb = rules.count();
        if (nb) {
            //Get std colors
            KColorScheme scheme(QPalette::Normal);
            QString negative = scheme.foreground(KColorScheme::NegativeText).color().name();
            QString neutral = scheme.foreground(KColorScheme::NeutralText).color().name();
            QString positive = scheme.foreground(KColorScheme::PositiveText).color().name();

            for (int i = 0; !err && i < nb; ++i) {
                SKGRuleObject rule = rules.at(i);
                SKGRuleObject::SKGAlarmInfo alarm = rule.getAlarmInfo();

                //Create progress bar
                QProgressBar* progressBar = new QProgressBar();
                progressBar->setObjectName(QString::fromUtf8("progressBar"));
                progressBar->setMaximum(qMax(alarm.Amount, alarm.Limit));
                progressBar->setValue(alarm.Amount);

                QSizePolicy sizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed);
                sizePolicy.setHorizontalStretch(0);
                sizePolicy.setVerticalStretch(0);
                sizePolicy.setHeightForWidth(progressBar->sizePolicy().hasHeightForWidth());
                progressBar->setSizePolicy(sizePolicy);

                //Set tooltip
                QString txt = alarm.Message % "<br>";
                txt += doc->formatMoney(alarm.Amount, primary) % " / " % doc->formatMoney(alarm.Limit, primary);
                if (!secondary.Symbol.isEmpty() && secondary.Value) {
                    txt += "<br>" % doc->formatMoney(alarm.Amount, secondary) % " / " % doc->formatMoney(alarm.Limit, secondary);
                }
                progressBar->setToolTip(txt);

                //Change color
                double percent = 100 * alarm.Amount / alarm.Limit;
                QString st = progressBar->styleSheet();
                st = QString(" QProgressBar { text-align: center; padding: 0.5px;} QProgressBar::chunk {text-align: center; border-radius:4px; background-color: ") % (percent < 70 ? positive : (percent > 90 ? negative : neutral)) % ";}" % st;
                progressBar->setStyleSheet(st);
                pw = new QGraphicsProxyWidget();
                pw->setWidget(progressBar);
                //Add progress bar
                gl_layout->addItem(pw);
                displayLabel->setText(txt);


            }
        }

    }
    gl_layout->addItem(displayLabel);
    gl_layout->addItem(check);
}



AlarmSkroogoid::~AlarmSkroogoid()
{
}


#include "alarmskroogoid.moc"
