/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bookmark management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbookmarkboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgoperationobject.h"
#include "skgmainpanel.h"

#include <QDomDocument>
#include "skgoperationplugin.h"

SKGBookmarkBoardWidget::SKGBookmarkBoardWidget(SKGDocument* iDocument)
    : SKGWidget(iDocument)
{
    SKGTRACEIN(10, "SKGBookmarkBoardWidget::SKGBookmarkBoardWidget");

    ui.setupUi(this);

    //Refresh
    connect((const QObject*) getDocument(), SIGNAL(tableModified(QString, int)), this, SLOT(dataModified(QString, int)), Qt::QueuedConnection);
    dataModified("", 0);
}

SKGBookmarkBoardWidget::~SKGBookmarkBoardWidget()
{
    SKGTRACEIN(10, "SKGBookmarkBoardWidget::~SKGBookmarkBoardWidget");

}

QString SKGBookmarkBoardWidget::getState()
{
    return "";
}

void SKGBookmarkBoardWidget::setState(const QString& iState)
{
    Q_UNUSED(iState);
    dataModified("", 0);
}

void SKGBookmarkBoardWidget::dataModified(const QString& iTableName, int iIdTransaction)
{
    SKGTRACEIN(10, "SKGBookmarkBoardWidget::dataModified");
    Q_UNUSED(iIdTransaction);

    if(iTableName == "v_operation_display" || iTableName.isEmpty()) {
        SKGObjectBase::SKGListSKGObjectBase objs;
        SKGError err = getDocument()->getObjects("v_operation_display", "t_bookmarked='Y' ORDER BY d_date", objs);
        if(!err) {
            QString html = "<html><body>";
            int nb = objs.count();
            if(nb) {
                for(int i = 0; i < nb; ++i) {
                    SKGOperationObject obj = objs.at(i);
                    html += "<a href=\"" % SKGServices::intToString(obj.getID()) % "\">" % SKGServices::stringToHtml(obj.getDisplayName()) % "</a><br>";
                }
            } else {
                html += i18nc("Message", "No operation highlighted<br>on the <a href=\"___\">\"Operations\"</a> page.");
            }
            html += "</body></html>";
            ui.kLabel->setText(html);
        }

        //No widget if no account
        bool exist = false;
        getDocument()->existObjects("account", "", exist);
        if(parentWidget()) setVisible(exist);
    }
}

void SKGBookmarkBoardWidget::onOpen()
{
    ui.kGroup->setChecked(true);
    SKGOperationPlugin::openHighLights();
}

void SKGBookmarkBoardWidget::onOpen(const QString& iLink)
{
    //Call operation plugin
    QDomDocument doc("SKGML");
    doc.setContent(getDocument()->getParameter("SKGOPERATION_DEFAULT_PARAMETERS"));
    if(iLink != "___") {
        QDomElement root = doc.documentElement();
        if(root.isNull()) {
            root = doc.createElement("parameters");
            doc.appendChild(root);
        }

        root.setAttribute("operationTable", "v_operation_display");
        root.setAttribute("operationWhereClause", "id=" % iLink);
        root.setAttribute("title", i18nc("Noun, a list of items", "Highlighted operations"));
        root.setAttribute("title_icon", "rating");
    }
    SKGMainPanel::getMainPanel()->openPage(SKGMainPanel::getMainPanel()->getPluginByName("Skrooge operation plugin"), -1, doc.toString());
}
#include "skgbookmarkboardwidget.moc"
