/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#ifndef UNITSKROOGOID_H
#define UNITSKROOGOID_H
/** @file
* This file is Plasma Applet for Shares & Indexes Skroogoid
*
* @author Siddharth SHARMA
*/
#include <Plasma/Applet>
#include <Plasma/Label>
#include <skgdocumentbank.h>

class QGraphicsLinearLayout;
/**
* Class UnitSkroogoid
*/
class UnitSkroogoid : public Plasma::Applet
{
    Q_OBJECT

public:
    /**
    * Default Constructor
    */
    UnitSkroogoid(QObject *parent, const QVariantList &args);


    /**
     * Reimplemented from Plasma::Applet
     */
    virtual void init();


    /**
    * Default Destructor
    */
    ~UnitSkroogoid();


private Q_SLOTS:
    /**
     * Reimplemented from Plasma::Applet
     */
    void dataUpdated(const QString &sourceName, const Plasma::DataEngine::Data &engineData);

    /**
     * Opens a new tab with the given unit
     */
    void openUnitTab();

private:

    /**
     * The current Skrooge document
     */
    SKGDocumentBank* doc;

    QGraphicsLinearLayout* widgetLayout;
};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(unitskroogoid, UnitSkroogoid)

#endif
