/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Income & Expenditure Skroogoid
*
* @author Siddharth SHARMA
*/

#include "operationskroogoid.h"
#include "skgdocumentbank.h"
#include "skgservices.h"
#include "skgmainpanel.h"

#include <QGraphicsGridLayout>
#include <QGraphicsLinearLayout>
#include <QProgressBar>
#include <QGraphicsProxyWidget>

OperationSkroogoid::OperationSkroogoid(QObject *parent, const QVariantList &args)
    : Plasma::PopupApplet(parent, args),
      m_widget(0),
      m_layout(0)
{
    setAspectRatioMode(Plasma::IgnoreAspectRatio);
    resize(300, 300);

    cincome_pw = new QGraphicsProxyWidget();
    cincome_progress = new QProgressBar(0);
    cincome_progress->setTextVisible(false);
    cincome_pw->setWidget(cincome_progress);

    cexpenditure_pw = new QGraphicsProxyWidget();
    cexpenditure_progress = new QProgressBar(0);
    cexpenditure_progress->setTextVisible(false);
    cexpenditure_pw->setWidget(cexpenditure_progress);

    pincome_pw = new QGraphicsProxyWidget();
    pincome_progress = new QProgressBar(0);
    pincome_progress->setTextVisible(false);
    pincome_pw->setWidget(pincome_progress);

    pexpenditure_pw = new QGraphicsProxyWidget();
    pexpenditure_progress = new QProgressBar(0);
    pexpenditure_progress->setTextVisible(false);
    pexpenditure_pw->setWidget(pexpenditure_progress);

    cmonth = new Plasma::Label;
    cmonth->setText(i18n("<b>Current Month</b>"));
    cmonth->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Ignored));

    cincome = new Plasma::Label;
    cincome->setText(i18n("Income"));

    cexpenditure = new Plasma::Label;
    cexpenditure->setText(i18n("Expenditure"));

    pincome = new Plasma::Label;
    pincome->setText(i18n("Income"));

    pexpenditure = new Plasma::Label;
    pexpenditure->setText(i18n("Expenditure"));

    pmonth = new Plasma::Label;
    pmonth->setText(i18n("<b>Previous Month</b>"));
    pmonth->setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Ignored));

    QGraphicsGridLayout* layout = new  QGraphicsGridLayout(this);
    QGraphicsLinearLayout* linearLayout = new QGraphicsLinearLayout(layout);

    //Get month
    QDate date = QDate::currentDate();
    date = date.addDays(1 - date.day());
    QDate date1 = date.addDays(-1);
    QString month = date.toString("yyyy-MM");
    QString previousmonth = date1.toString("yyyy-MM");


    SKGMainPanel* panel = SKGMainPanel::getMainPanel();
    SKGDocumentBank* doc = qobject_cast<SKGDocumentBank*>(panel->getDocument());
    if(doc) {

        SKGServices::SKGUnitInfo primary = doc->getPrimaryUnit();
        SKGServices::SKGUnitInfo secondary = doc->getSecondaryUnit();

        SKGStringListList listTmp;
        SKGError err = doc->executeSelectSqliteOrder(
                           "SELECT TOTAL(f_CURRENTAMOUNT), d_DATEMONTH  from v_operation_display WHERE d_DATEMONTH IN ('" % month % "', '" % previousmonth % "') AND i_group_id=0 group by d_DATEMONTH, t_TYPEEXPENSE",
                           listTmp);
        if(!err) {
            double income_previous_month = 0;
            double expense_previous_month = 0;
            double income_month = 0;
            double expense_month = 0;

            int nbval = listTmp.count();
            for(int i = 1; i < nbval; ++i) {  //Ignore header
                QString m = listTmp.at(i).at(1);
                double v = SKGServices::stringToDouble(listTmp.at(i).at(0));
                if(v > 0 && m == month) income_month = v;
                else if(v < 0 && m == month) expense_month = -v;
                else if(v > 0 && m == previousmonth) income_previous_month = v;
                else if(v < 0 && m == previousmonth) expense_previous_month = -v;
            }

            //Set Maximum
            int max = qMax(income_previous_month, qMax(expense_previous_month, qMax(income_month, expense_month)));
            if(nbval == 1) max = 100.0;
            cincome_progress->setMaximum(max);
            pincome_progress->setMaximum(max);
            cexpenditure_progress->setMaximum(max);
            pexpenditure_progress->setMaximum(max);

            //Set value
            cincome_progress->setValue(income_month);
            pincome_progress->setValue(income_previous_month);
            cexpenditure_progress->setValue(expense_month);
            pexpenditure_progress->setValue(expense_previous_month);

            //Set tool tips
            QString tmp = doc->formatMoney(income_month, primary);
            if(!secondary.Symbol.isEmpty() && secondary.Value) {
                tmp += "<br>" % doc->formatMoney(income_month, secondary);
            }
            cincome_progress->setToolTip(tmp);

            tmp = doc->formatMoney(income_previous_month, primary);
            if(!secondary.Symbol.isEmpty() && secondary.Value) {
                tmp += "<br>" % doc->formatMoney(income_previous_month, secondary);
            }
            pincome_progress->setToolTip(tmp);

            tmp = doc->formatMoney(expense_month, primary);
            if(!secondary.Symbol.isEmpty() && secondary.Value) {
                tmp += "<br>" % doc->formatMoney(expense_month, secondary);
            }
            cexpenditure_progress->setToolTip(tmp);

            tmp = doc->formatMoney(expense_previous_month, primary);
            if(!secondary.Symbol.isEmpty() && secondary.Value) {
                tmp += "<br>" % doc->formatMoney(expense_previous_month, secondary);
            }
            pexpenditure_progress->setToolTip(tmp);
        }

        //No widget if no account
        bool exist = false;
        panel->getDocument()->existObjects("account", "", exist);
        if(parentWidget()) setVisible(exist);
    }
    spacer = new Plasma::Label();
    layout->addItem(linearLayout, 0, 0, 1, 4);
    layout->addItem(cmonth, 1, 0, 1, 1);
    layout->addItem(cincome, 2, 0, 1, 1);
    layout->addItem(cincome_pw, 2, 1, 1, 1);
    layout->addItem(cexpenditure, 3, 0, 1, 1);
    layout->addItem(cexpenditure_pw, 3, 1, 1, 1);
    layout->addItem(pmonth, 4, 0, 1, 1);
    layout->addItem(pincome, 5, 0, 1, 1);
    layout->addItem(pincome_pw, 5, 1, 1, 1);
    layout->addItem(pexpenditure, 6, 0, 1, 1);
    layout->addItem(pexpenditure_pw, 6, 1, 1, 1);
    layout->addItem(spacer, 7, 1, 1, 1);

    setPreferredSize(260, 220);
    //setMinimumSize(260,200);
}


OperationSkroogoid::~OperationSkroogoid()
{
}


#include "operationskroogoid.moc"
