/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A skrooge plugin to track operations
 *
 * @author Stephane MANKOWSKI
 */
#include "skgtrackerplugin.h"
#include "skgtrackerpluginwidget.h"
#include "skgtracker_settings.h"
#include "skgtraces.h"
#include "skgdocumentbank.h"

#include <kactioncollection.h>
#include <kstandardaction.h>
#include <kaboutdata.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGTrackerPluginFactory, registerPlugin<SKGTrackerPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGTrackerPluginFactory("skrooge_tracker", "skrooge_tracker"))

SKGTrackerPlugin::SKGTrackerPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
    SKGTRACEIN(10, "SKGTrackerPlugin::SKGTrackerPlugin");
}

SKGTrackerPlugin::~SKGTrackerPlugin()
{
    SKGTRACEIN(10, "SKGTrackerPlugin::~SKGTrackerPlugin");
    m_currentBankDocument = NULL;
}

bool SKGTrackerPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEIN(10, "SKGTrackerPlugin::setupActions");
    Q_UNUSED(iArgument);
    if(qobject_cast<SKGDocumentBank*>(iDocument) == NULL) return false;

    m_currentBankDocument = iDocument;

    KComponentData data = SKGTrackerPluginFactory::componentData();
    const_cast<KAboutData*>(data.aboutData())->setProgramName(ki18n("%1").subs(KGlobal::mainComponent().aboutData()->programName()));
    setComponentData(data);
    setXMLFile("skrooge_tracker.rc");

    //Create yours actions here
    return true;
}

void SKGTrackerPlugin::refresh()
{
    SKGTRACEIN(10, "SKGTrackerPlugin::refresh");
}

void SKGTrackerPlugin::close()
{
    SKGTRACEIN(10, "SKGTrackerPlugin::close");
}

SKGTabPage* SKGTrackerPlugin::getWidget()
{
    SKGTRACEIN(10, "SKGTrackerPlugin::getWidget");
    return new SKGTrackerPluginWidget(m_currentBankDocument);
}

QWidget* SKGTrackerPlugin::getPreferenceWidget()
{
    SKGTRACEIN(10, "SKGTrackerPlugin::getPreferenceWidget");
    //QWidget* widget=new QWidget();
    //ui.setupUi(widget);

    return NULL;
}

KConfigSkeleton* SKGTrackerPlugin::getPreferenceSkeleton()
{
    return skgtracker_settings::self();
}

QString SKGTrackerPlugin::title() const
{
    return i18nc("Noun, something that is used to track items", "Trackers");
}

QString SKGTrackerPlugin::icon() const
{
    return "skrooge_tracker";
}

QString SKGTrackerPlugin::toolTip() const
{
    return i18nc("A tool tip", "Trackers management");
}

int SKGTrackerPlugin::getOrder() const
{
    return 25;
}

QStringList SKGTrackerPlugin::tips() const
{
    QStringList output;
    output.push_back(i18nc("Description of a tips", "<p>...you can follow your refunds by using a tracker.</p>"));
    return output;
}

bool SKGTrackerPlugin::isInContext() const
{
    return true;
}

QList< SKGInterfacePlugin::SKGAdvice > SKGTrackerPlugin::advices() const
{
    SKGTRACEIN(10, "SKGTrackerPlugin::advices");
    QList< SKGInterfacePlugin::SKGAdvice > output;
    //Search old trackers
    SKGStringListList result;
    m_currentBankDocument->executeSelectSqliteOrder("SELECT t_name  FROM v_refund_display WHERE t_close='N' AND julianday('now')-julianday(d_FIRSTDATE)>300 ORDER BY julianday('now')-julianday(d_FIRSTDATE) DESC;", result);
    int nb = result.count();
    for(int i = 1; i < nb; ++i) {  //Ignore header
        SKGInterfacePlugin::SKGAdvice ad;
        ad.uuid = "skgtrackerplugin_old";
        ad.priority = 2;
        ad.shortMessage = i18nc("Advice on making the best (short)", "'%1' is an old tracker", result.at(i).at(0));
        ad.longMessage = i18nc("Advice on making the best (long)", "This tracker does not contain recent operation. You may want to close it if you do not intend to add other operations");
        output.push_back(ad);
    }

    return output;
}

SKGError SKGTrackerPlugin::executeAdviceCorrection(const QString& iAdviceIdentifier, int iSolution) const
{
    return SKGInterfacePlugin::executeAdviceCorrection(iAdviceIdentifier, iSolution);
}
#include "skgtrackerplugin.moc"
