/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgreportboardwidget.h"
#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgmainpanel.h"
#include "skgreportpluginwidget.h"

#include <kinputdialog.h>

SKGReportBoardWidget::SKGReportBoardWidget(SKGDocumentBank* iDocument)
    : SKGWidget(iDocument)
{
    SKGTRACEIN(10, "SKGReportBoardWidget::SKGReportBoardWidget");

    ui.setupUi(this);
    //Create menu
    setContextMenuPolicy(Qt::ActionsContextMenu);

    m_menuRename = new KAction(KIcon("edit-rename"), i18nc("Verb, change the name of an item", "Rename"), this);
    connect(m_menuRename, SIGNAL(triggered(bool)), this, SLOT(onRenameTitle()));
    addAction(m_menuRename);

    m_graph = new SKGReportPluginWidget(iDocument, true);
    ui.gridLayout->addWidget(m_graph, 0, 0, 1, 1);
    this->setMinimumSize(200, 200);

    //Refresh
    connect((const QObject*) getDocument(), SIGNAL(tableModified(QString, int)), this, SLOT(dataModified(QString, int)), Qt::QueuedConnection);
}

SKGReportBoardWidget::~SKGReportBoardWidget()
{
    SKGTRACEIN(10, "SKGReportBoardWidget::~SKGReportBoardWidget");
    m_graph = NULL;
    m_menuRename = NULL;
}

QString SKGReportBoardWidget::getState()
{
    QDomDocument doc("SKGML");
    QDomElement root = doc.createElement("parameters");
    doc.appendChild(root);

    root.setAttribute("title", ui.kGroup->title());
    if(m_graph) root.setAttribute("graph", m_graph->getState());
    return doc.toString();

    //return ( graph ? graph->getState() : "" );
}

void SKGReportBoardWidget::setState(const QString& iState)
{
    QDomDocument doc("SKGML");
    if(doc.setContent(iState)) {
        QDomElement root = doc.documentElement();

        QString title = root.attribute("title");
        if(!title.isEmpty()) ui.kGroup->setTitle(title);


        QString graphS = root.attribute("graph");
        if(m_graph) {
            if(graphS.isEmpty()) m_graph->setState(iState);
            else m_graph->setState(graphS);
        }
    }

    dataModified("", 0);
}

void SKGReportBoardWidget::onRenameTitle()
{
    bool ok = false;
    QString newTitle = KInputDialog::getText(i18nc("Question", "Title"),
                       i18nc("Question", "New title:"), ui.kGroup->title(), &ok, SKGMainPanel::getMainPanel());
    if(ok) {
        ui.kGroup->setTitle(newTitle);
    }
}

void SKGReportBoardWidget::dataModified(const QString& iTableName, int iIdTransaction)
{
    SKGTRACEIN(10, "SKGReportBoardWidget::dataModified");
    Q_UNUSED(iIdTransaction);
    if(iTableName == "operation" || iTableName.isEmpty()) {
        bool exist = false;
        getDocument()->existObjects("account", "", exist);
        if(parentWidget()) setVisible(exist);
    }
}

void SKGReportBoardWidget::onOpen()
{
    ui.kGroup->setChecked(true);

    QDomDocument doc("SKGML");
    QString graphS;
    if(doc.setContent(getState())) {
        QDomElement root = doc.documentElement();

        QString title = root.attribute("title");
        if(!title.isEmpty()) ui.kGroup->setTitle(title);


        graphS = root.attribute("graph");
    }
    SKGMainPanel::getMainPanel()->openPage(SKGMainPanel::getMainPanel()->getPluginByName("Skrooge report plugin"), -1, graphS);
}

#include "skgreportboardwidget.moc"
