/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGBUDGETPLUGINWIDGET_H
#define SKGBUDGETPLUGINWIDGET_H
/** @file
 * A skrooge plugin to manage budgets
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgbudgetpluginwidget_base.h"
#include "skgtabpage.h"

class SKGObjectModel;
class SKGBudgetObject;
class SKGBudgetRuleObject;

/**
 * A skrooge plugin to manage budgets
 */
class SKGBudgetPluginWidget : public SKGTabPage
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    SKGBudgetPluginWidget(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGBudgetPluginWidget();

    /**
     * Get the current state
     * MUST BE OVERWRITTEN
     * @return a string containing all information needed to set the same state.
     * Could be an XML stream
     */
    virtual QString getState();

    /**
     * Set the current state
     * MUST BE OVERWRITTEN
     * @param iState must be interpreted to set the state of the widget
     */
    virtual void setState(const QString& iState);

    /**
     * Get attribute name to save the default state
     * MUST BE OVERWRITTEN
     * @return attribute name to save the default state.
     */
    virtual QString getDefaultStateAttribute();

    /**
     * Get the main widget
     * @return a widget
     */
    virtual QWidget* mainWidget() const;

    /**
     * To know if this page contains an editor. MUST BE OVERWRITTEN
     * @return the editor state
     */
    virtual bool isEditor();

    /**
     * To activate the editor by setting focus on right widget. MUST BE OVERWRITTEN
     */
    virtual void activateEditor();
    /**
     * Open operations corresponding to a budget
     * @param iBudget a budget
     */
    static void open(const SKGBudgetObject& iBudget);

public Q_SLOTS:
    /**
    * Refresh the content.
     */
    virtual void refresh();

protected:
    /**
     * Event filtering
     * @param object object
     * @param event event
     * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
     */
    virtual bool eventFilter(QObject *object, QEvent *event);

private Q_SLOTS:
    void dataModified(const QString& iTableName, int iIdTransaction);
    void onCreatorModified();
    void onAddClicked();
    void onUpdateClicked();
    void onDoubleClick();
    void onBtnModeClicked();
    void onSelectionChanged();
    void onProcessRules();
private:
    Q_DISABLE_COPY(SKGBudgetPluginWidget);

    Ui::skgbudgetplugin_base ui;

    int getCurrentMode();
    void setCurrentMode(int iMode);
    SKGError updateBudget(SKGBudgetObject& iBudget, int iMonth = -1);
    SKGError updateBudgetRule(SKGBudgetRuleObject& iRule);

    SKGObjectModel* m_objectModel;
    int m_mode;
    QString m_viewBudget;
    QString m_viewRule;
};

#endif // SKGBUDGETPLUGINWIDGET_H
