/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGBANKBOARDWIDGET_H
#define SKGBANKBOARDWIDGET_H
/** @file
* This file is Skrooge plugin for bank management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgbankpluginwidget_board.h"
#include "skgwidget.h"

class KAction;

/**
 * This file is Skrooge plugin for bank management
 */
class SKGBankBoardWidget : public SKGWidget
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     */
    SKGBankBoardWidget(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGBankBoardWidget();

private Q_SLOTS:
    void dataModified(const QString& iTableName = "", int iIdTransaction = 0);
    void onOpen(const QString& iLink);

private:
    Q_DISABLE_COPY(SKGBankBoardWidget);

    Ui::skgbankplugin_board ui;
};

#endif // SKGBANKBOARDWIDGET_H
