/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"


/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    //Init test
    SKGINITTEST(true);

    //test class SKGDocument / PARAMETERS
    SKGDocument document1;
    SKGTESTERROR("PARAM:initialize", document1.initialize(), true);
    SKGTESTERROR("PARAM:beginTransaction", document1.beginTransaction("t1"), true);
    SKGTESTERROR("PARAM:setParameter", document1.setParameter("ATT1", "VAL1"), true);
    SKGTESTERROR("PARAM:endTransaction", document1.endTransaction(true), true);
    SKGTEST("PARAM:getCachedValue", document1.getCachedValue("NOTFOUND"), "");

    SKGDocument document2;
    SKGTESTERROR("PARAM:initialize", document2.initialize(), true);
    SKGTESTERROR("PARAM:beginTransaction", document2.beginTransaction("t2"), true);
    SKGTESTERROR("PARAM:setParameter", document2.setParameter("ATT2", "VAL2"), true);
    SKGTESTERROR("PARAM:endTransaction", document2.endTransaction(true), true);


    SKGTEST("PARAM:getParameter", document1.getParameter("ATT1"), "VAL1");
    SKGTEST("PARAM:getParameter", document2.getParameter("ATT2"), "VAL2");

    //End test
    SKGENDTEST();
}
