/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include <QFile>

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    //Init test
    SKGINITTEST(true);
    {
        //test class SKGDocument / LOAD / SAVE
        QString filename1 = getTestPath("IN") + QString::fromUtf8("/filename1_e.skg"); //TODO: does not work if file name contains accents
        qDebug("filename1=%s", filename1.toUtf8().constData());
        {
            SKGDocument document1;
            QFile(filename1).remove();
            SKGTESTERROR("DOC:initialize", document1.initialize(), true);
            SKGTESTERROR("DOC:setLanguage", document1.setLanguage("en"), true);
            SKGTESTERROR("DOC:setLanguage", document1.setLanguage("fr"), true);
            SKGTEST("DOC:isFileModified", document1.isFileModified(), false);

            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("tt"), true);
            SKGTESTERROR("DOC:setParameter", document1.setParameter("ATT3", "VAL3"), true);
            SKGTEST("DOC:isFileModified", document1.isFileModified(), true);
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(false), true);
            SKGTEST("DOC:isFileModified", document1.isFileModified(), false);
            SKGTEST("DOC:getDisplay", document1.getDisplay("t_name"), "Name");
            SKGTEST("DOC:getDisplay", document1.getDisplay("node.t_name"), "Name");
            SKGTEST("DOC:getDisplay", document1.getDisplay("v_node.t_name"), "Name");
            SKGTEST("DOC:getDisplay", document1.getDisplay("v_node.unknown"), "v_node.unknown");

            QString oResult;
            SKGTESTERROR("DOC:isFileModified", document1.dumpSelectSqliteOrder("select * from parameters", oResult), true);
        }
        {
            SKGDocument document1;
            QFile(filename1).remove();
            SKGTESTERROR("DOC:initialize", document1.initialize(), true);
            SKGTEST("DOC:isFileModified", document1.isFileModified(), false);

            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("tt"), true);
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);
            SKGTEST("DOC:isFileModified", document1.isFileModified(), false); //because the transaction is empty

        }
        {
            SKGDocument document1;
            QFile(filename1).remove();
            SKGTESTERROR("DOC:load", document1.load(filename1, ""), false);
            SKGTESTERROR("DOC:saveAs+invalid path", document1.saveAs("/notfound/file.skg", true), false);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), "");
            SKGTEST("DOC:isFileModified", document1.isFileModified(), false);
            SKGTESTERROR("DOC:initialize", document1.initialize(), true);
            SKGTEST("DOC:isFileModified", document1.isFileModified(), false);
            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("t1"), true);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), "");
            SKGTESTERROR("DOC:save", document1.save(), false);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), "");
            SKGTEST("DOC:isFileModified", document1.isFileModified(), true); //due to the beginTransaction
            SKGTEST("DOC:getParameter", document1.getParameter("ATT1"), "");
            SKGTESTERROR("DOC:setParameter", document1.setParameter("ATT1", "VAL1"), true);
            SKGTEST("DOC:isFileModified", document1.isFileModified(), true);
            SKGTEST("DOC:getParameter", document1.getParameter("ATT1"), "VAL1");
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);
            SKGTESTERROR("DOC:saveAs+overwrite=false", document1.saveAs(filename1, false), true);
            SKGTEST("DOC:exist", QFile(filename1).exists(), true);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), filename1);
            SKGTESTERROR("DOC:saveAs+overwrite=false", document1.saveAs(filename1, false), false);
            SKGTEST("DOC:exist", QFile(filename1).exists(), true);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), filename1);
            SKGTESTERROR("DOC:save", document1.save(), true);
            SKGTEST("DOC:exist", QFile(filename1).exists(), true);
            SKGTEST("DOC:getCurrentFileName", document1.getCurrentFileName(), filename1);

            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("t1"), true);
            SKGTEST("DOC:isFileModified", document1.isFileModified(), true); //due to the beginTransaction
            SKGTEST("DOC:getParameter", document1.getParameter("ATT1"), "VAL1");
            SKGTESTERROR("DOC:setParameter", document1.setParameter("ATT1", "VAL2"), true);
            SKGTEST("DOC:getParameter", document1.getParameter("ATT1"), "VAL2");
            SKGTEST("DOC:isFileModified", document1.isFileModified(), true);
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);

            SKGTEST("DOC:exist", QFile(filename1).exists(), true);
            SKGTESTERROR("DOC:load", document1.load(filename1, ""), true);
            SKGTEST("DOC:isFileModified", document1.isFileModified(), false);
            SKGTEST("DOC:getCurrentFileName", (document1.getCurrentFileName().length() > 0), true);
            SKGTEST("DOC:getParameter", document1.getParameter("ATT1"), "VAL1");
        }

        {
            SKGDocument document1;
            SKGTESTERROR("DOC:load", document1.load(filename1, ""), true);
            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("t3"), true);
            SKGTESTERROR("DOC:setParameter", document1.setParameter("ATT3", "VAL3"), true);
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);
            SKGTESTERROR("DOC:save", document1.save(), true);

            SKGTESTERROR("DOC:beginTransaction", document1.beginTransaction("tt"), true);
            SKGTESTERROR("DOC:changePassword", document1.changePassword("pwd"), true);
            SKGTESTERROR("DOC:endTransaction", document1.endTransaction(true), true);
            SKGTESTERROR("DOC:save", document1.save(), true);
        }
        {
            SKGDocument document1;
            SKGTESTERROR("DOC:load", document1.load(filename1, ""), false);
            SKGTESTERROR("DOC:load", document1.load(filename1, "pwd"), true);
        }

        QFile(filename1).remove();
    }
    //End test
    SKGENDTEST();
}
