/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test for SKGComboBox component.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestcombobox.h"
#include "skgcombobox.h"

#include <qtestkeyboard.h>


void SKGTESTComboBox::Test()
{
    SKGComboBox combo;
    QVERIFY(combo.text() == "");
    combo.setText("Hello");
    QVERIFY(combo.text() == "Hello");

    combo.setEditable(false);
    QTest::keyClicks(&combo, "ABCD");
    QCOMPARE(combo.text(), QString("Hello"));

    combo.setEditable(true);
    QTest::keyClicks(&combo, "ABCD");
    QCOMPARE(combo.text(), QString("HelloABCD"));

}

QTEST_KDEMAIN(SKGTESTComboBox, GUI)
#include "skgtestcombobox.moc"
