/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test for SKGCalculatorEdit component.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestcalculatoredit.h"
#include "skgcalculatoredit.h"

#include <qtestkeyboard.h>
#include <QTestEventList>

void SKGTESTCalculatorEdit::TestValueCALCULATOR_data()
{
    QTest::addColumn<QTestEventList>("events");
    QTest::addColumn<double>("expected");

    {
        QTestEventList list;
        list.addKeyClicks("5.1");
        QTest::newRow("simple positive value") << list << 5.1;
    }

    {
        QTestEventList list;
        list.addKeyClicks("-7.2");
        QTest::newRow("simple negative value") << list << -7.2;
    }

    {
        QTestEventList list;
        list.addKeyClicks("10+5");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter +") << list << 15.0;
    }

    {
        QTestEventList list;
        list.addKeyClicks("3.5*3");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter *") << list << 10.5;
    }

    {
        QTestEventList list;
        list.addKeyClicks("5/2");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter /") << list << 2.5;
    }

    {
        QTestEventList list;
        list.addKeyClicks("-5*2/4-6.2+3.1+4.5");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter complex operation") << list << -1.1;
    }

    {
        QTestEventList list;
        list.addKeyClicks("3,5*3");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter ,") << list << 10.5;
    }
}


void SKGTESTCalculatorEdit::TestValueCALCULATOR()
{
    QFETCH(QTestEventList, events);
    QFETCH(double, expected);

    SKGCalculatorEdit calculator;
    calculator.setMode(SKGCalculatorEdit::CALCULATOR);
    events.simulate(&calculator);

    QCOMPARE(calculator.value(), expected);
}

void SKGTESTCalculatorEdit::TestValueEXPRESSION_data()
{
    QTest::addColumn<QTestEventList>("events");
    QTest::addColumn<double>("expected");

    {
        QTestEventList list;
        list.addKeyClicks("5.1");
        QTest::newRow("simple positive value") << list << 5.1;
    }

    {
        QTestEventList list;
        list.addKeyClicks("-7.2");
        QTest::newRow("simple negative value") << list << -7.2;
    }

    {
        QTestEventList list;
        list.addKeyClicks("10+5");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter +") << list << 15.0;
    }

    {
        QTestEventList list;
        list.addKeyClicks("3.5*3");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter *") << list << 10.5;
    }

    {
        QTestEventList list;
        list.addKeyClicks("5/2");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter /") << list << 2.5;
    }

    {
        QTestEventList list;
        list.addKeyClicks("-5*2/4-6.2+3.1+4.5");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter complex operation") << list << -1.1;
    }

    {
        QTestEventList list;
        list.addKeyClicks("3,5*3");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter ,") << list << 10.5;
    }
}


void SKGTESTCalculatorEdit::TestValueEXPRESSION()
{
    QFETCH(QTestEventList, events);
    QFETCH(double, expected);

    SKGCalculatorEdit calculator;
    calculator.setMode(SKGCalculatorEdit::EXPRESSION);
    events.simulate(&calculator);

    QCOMPARE(calculator.value(), expected);
}

void SKGTESTCalculatorEdit::TestString_data()
{
    QTest::addColumn<QTestEventList>("events");
    QTest::addColumn<QString>("expected");
    {
        QTestEventList list;
        list.addKeyClicks("3,5*3");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("enter , as string") << list << "10.5";
    }

    {
        QTestEventList list;
        list.addKeyClicks("5a");
        list.addKeyClick(Qt::Key_Return);
        QTest::newRow("invalid expression") << list << "5a";
    }
}

void SKGTESTCalculatorEdit::TestString()
{
    QFETCH(QTestEventList, events);
    QFETCH(QString, expected);

    SKGCalculatorEdit calculator;
    calculator.setMode(SKGCalculatorEdit::EXPRESSION);
    events.simulate(&calculator);

    QCOMPARE(calculator.text(), expected);

}

void SKGTESTCalculatorEdit::TestSign_data()
{
    QTest::addColumn<QTestEventList>("events");
    QTest::addColumn<int>("expected");

    {
        QTestEventList list;
        list.addKeyClicks("5.1");
        QTest::newRow("simple positive value") << list << 0;
    }

    {
        QTestEventList list;
        list.addKeyClicks("-7.2");
        QTest::newRow("simple negative value") << list << -1;
    }

    {
        QTestEventList list;
        list.addKeyClicks("+7.2");
        QTest::newRow("simple positive value") << list << 1;
    }
}

void SKGTESTCalculatorEdit::TestSign()
{
    QFETCH(QTestEventList, events);
    QFETCH(int, expected);

    SKGCalculatorEdit calculator;
    calculator.setMode(SKGCalculatorEdit::CALCULATOR);
    events.simulate(&calculator);

    QCOMPARE(calculator.sign(), expected);

}



QTEST_KDEMAIN(SKGTESTCalculatorEdit, GUI)
#include "skgtestcalculatoredit.moc"
