/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGTABLEWIDGET_H
#define SKGTABLEWIDGET_H
/** @file
 * A table widget with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include <QTableWidget>
#include "skgbasegui_export.h"
/**
 * This file is a combo box with more features.
 */
class SKGBASEGUI_EXPORT SKGTableWidget : public QTableWidget
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     * @param parent the parent
     */
    SKGTableWidget(QWidget *parent = 0);

    /**
     * Default Destructor
     */
    virtual ~SKGTableWidget();

Q_SIGNALS:
    /**
     * Selected items must be removed
     */
    void removeSelectedItems();

protected:
    /**
     * Event filtering
     * @param object object
     * @param event event
     * @return In your reimplementation of this function, if you want to filter the event out, i.e. stop it being handled further, return true; otherwise return false.
     */
    virtual bool eventFilter(QObject *object, QEvent *event);
};

#endif // SKGTABLEWIDGET_H
