/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGLINEEDIT_H
#define SKGLINEEDIT_H
/** @file
 * A line edit with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include <klineedit.h>
#include "skgbasegui_export.h"
/**
 * This file is a line edit with more features.
 */
class SKGBASEGUI_EXPORT SKGLineEdit : public KLineEdit
{
    Q_OBJECT
    /**
     * Autocompletion mode
     */
    Q_PROPERTY(bool substringCompletionMode READ substringCompletionMode WRITE setSubstringCompletionMode USER true)

public:
    /**
     * Default Constructor
     * @param parent the parent
     */
    SKGLineEdit(QWidget *parent = 0);

    /**
     * Default Destructor
     */
    virtual ~SKGLineEdit();

    /**
     * Get the completion mode
     * @return the mode
     */
    virtual bool substringCompletionMode() const;


    /**
     * Set the completion on substring or not
     * @param iMode the mode
     */
    virtual void setSubstringCompletionMode(bool iMode);

protected Q_SLOTS:

    /**
    * Completes the remaining text with a matching one from
    * a given list.
    */
    virtual void makeCompletion(const QString&);

private:
    bool m_substringCompletionMode;
};

#endif // SKGLINEEDIT_H
