/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A Graphic view with more features (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skggraphicsviewdesignerplugin.h"
#include "skggraphicsview.h"

#include "kicon.h"

#include <QtPlugin>

SKGGraphicsViewDesignerPlugin::SKGGraphicsViewDesignerPlugin(QObject *parent)
    : QObject(parent)
{
    m_initialized = false;
}

void SKGGraphicsViewDesignerPlugin::initialize(QDesignerFormEditorInterface * /* core */)
{
    if(m_initialized) return;

    m_initialized = true;
}

bool SKGGraphicsViewDesignerPlugin::isInitialized() const
{
    return m_initialized;
}

QWidget *SKGGraphicsViewDesignerPlugin::createWidget(QWidget *parent)
{
    return new SKGGraphicsView(parent);
}

QString SKGGraphicsViewDesignerPlugin::name() const
{
    return "SKGGraphicsView";
}

QString SKGGraphicsViewDesignerPlugin::group() const
{
    return "SKG Widgets";
}

QIcon SKGGraphicsViewDesignerPlugin::icon() const
{
    return KIcon("skg_open");
}

QString SKGGraphicsViewDesignerPlugin::toolTip() const
{
    return "A Graphic view";
}

QString SKGGraphicsViewDesignerPlugin::whatsThis() const
{
    return "A Graphic view";
}

bool SKGGraphicsViewDesignerPlugin::isContainer() const
{
    return false;
}

QString SKGGraphicsViewDesignerPlugin::domXml() const
{
    return "<widget class=\"SKGGraphicsView\" name=\"SKGGraphicsView\">\n"
           " <property name=\"geometry\">\n"
           "  <rect>\n"
           "   <x>0</x>\n"
           "   <y>0</y>\n"
           "   <width>100</width>\n"
           "   <height>100</height>\n"
           "  </rect>\n"
           " </property>\n"
           "</widget>\n";
}

QString SKGGraphicsViewDesignerPlugin::includeFile() const
{
    return "skggraphicsview.h";
}

