/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A combo box with more features (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgcomboboxdesignerplugin.h"
#include "skgcombobox.h"

#include "kicon.h"

#include <QtPlugin>

SKGComboBoxDesignerPlugin::SKGComboBoxDesignerPlugin(QObject *parent)
    : QObject(parent)
{
    m_initialized = false;
}

void SKGComboBoxDesignerPlugin::initialize(QDesignerFormEditorInterface * /* core */)
{
    if(m_initialized) return;

    m_initialized = true;
}

bool SKGComboBoxDesignerPlugin::isInitialized() const
{
    return m_initialized;
}

QWidget *SKGComboBoxDesignerPlugin::createWidget(QWidget *parent)
{
    return new SKGComboBox(parent);
}

QString SKGComboBoxDesignerPlugin::name() const
{
    return "SKGComboBox";
}

QString SKGComboBoxDesignerPlugin::group() const
{
    return "SKG Widgets";
}

QIcon SKGComboBoxDesignerPlugin::icon() const
{
    return KIcon("skg_open");
}

QString SKGComboBoxDesignerPlugin::toolTip() const
{
    return "A combo box with more features";
}

QString SKGComboBoxDesignerPlugin::whatsThis() const
{
    return "A combo box with more features";
}

bool SKGComboBoxDesignerPlugin::isContainer() const
{
    return false;
}

QString SKGComboBoxDesignerPlugin::domXml() const
{
    return "<widget class=\"SKGComboBox\" name=\"SKGComboBox\">\n"
           " <property name=\"geometry\">\n"
           "  <rect>\n"
           "   <x>0</x>\n"
           "   <y>0</y>\n"
           "   <width>100</width>\n"
           "   <height>10</height>\n"
           "  </rect>\n"
           " </property>\n"
           "</widget>\n";
}

QString SKGComboBoxDesignerPlugin::includeFile() const
{
    return "skgcombobox.h";
}

