/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGCOMBOBOX_H
#define SKGCOMBOBOX_H
/** @file
 * A combo box with more features.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include <kcombobox.h>
#include "skgbasegui_export.h"
/**
 * This file is a combo box with more features.
 */
class SKGBASEGUI_EXPORT SKGComboBox : public KComboBox
{
    Q_OBJECT
    /**
     * Text of the combobox
     */
    Q_PROPERTY(QString text READ text WRITE setText USER true)
    /**
     * Autocompletion mode
     */
    Q_PROPERTY(bool substringCompletionMode READ substringCompletionMode WRITE setSubstringCompletionMode)

public:
    /**
     * Default Constructor
     * @param parent the parent
     */
    SKGComboBox(QWidget *parent = 0);

    /**
     * Default Destructor
     */
    virtual ~SKGComboBox();

    /**
     * Get the text for the combo
     * @return the text
     */
    virtual QString text() const;


    /**
     * Set the text for the combo
     * @param iText the text
     */
    virtual void setText(const QString& iText);

    /**
     * Set the Palette for the combobox.
     * Reimplemented since the base method does
     * not apply the Palette to the underlying
     * QlineEdit
     * @param palette the new palette
     */
    virtual void setPalette(const QPalette& palette);

    /**
     * "Re-implemented" so that setEditable(true) creates a SKGLineEdit
     * instead of KLineEdit.
     */
    virtual void setEditable(bool editable);

    /**
     * Get the completion mode
     * @return the mode
     */
    virtual bool substringCompletionMode() const;


    /**
     * Set the completion on substring or not
     * @param iMode the mode
     */
    virtual void setSubstringCompletionMode(bool iMode);

private:
    bool m_substringCompletionMode;
};

#endif // SKGCOMBOBOX_H
