/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    //Init test
    SKGINITTEST(true);

    {
        //Test import SKG
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_SKG", err);

            SKGImportExportManager imp1(&document1, getTestPath("IN") + "/skgtestimportskg/all_types.skg");
            SKGTESTERROR("SKG.importFile", imp1.importFile(), true);
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("SKG.setName", account.setName("FRANC"), true);
            SKGTESTERROR("SKG.load", account.load(), true);
            SKGTEST("SKG:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1.524490172");
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("SKG.setName", account.setName("COURANT"), true);
            SKGTESTERROR("SKG.load", account.load(), true);
            SKGTEST("SKG:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "-55");
        }
        {
            SKGAccountObject account(&document1);
            SKGTESTERROR("SKG.setName", account.setName("EPARGNE"), true);
            SKGTESTERROR("SKG.load", account.load(), true);
            SKGTEST("SKG:getCurrentAmount", SKGServices::doubleToString(account.getCurrentAmount()), "1130.52449");
        }

        //test multi import
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_SKG", err);

            SKGImportExportManager imp1(&document1, getTestPath("IN") + "/skgtestimportskg/all_types.skg");
            SKGTESTERROR("SKG.importFile", imp1.importFile(), true);
        }

        //Export xml
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "EXPORT_XML", err);

            SKGImportExportManager imp1(&document1, getTestPath("OUT") + "/skgtestimportskg/all_types.xml");
            SKGTESTERROR("SKG.exportFile", imp1.exportFile(), true);
        }

        //Export skg
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "EXPORT_SKG", err);

            SKGImportExportManager imp1(&document1, getTestPath("OUT") + "/skgtestimportskg/all_types_exp_from_mem.skg");
            SKGTESTERROR("SKG.exportFile", imp1.exportFile(), true);
        }
        SKGTESTERROR("SKG.saveAs", document1.saveAs(getTestPath("OUT") + "/skgtestimportskg/all_types_save.skg", true), true);
        SKGTESTERROR("SKG.load", document1.load(getTestPath("OUT") + "/skgtestimportskg/all_types_save.skg"), true);
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "EXPORT_SKG", err);

            SKGImportExportManager imp1(&document1, getTestPath("OUT") + "/skgtestimportskg/all_types_exp_from_file.skg");
            SKGTESTERROR("SKG.exportFile", imp1.exportFile(), true);
        }

        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "EXPORT_SQLITE", err);

            SKGImportExportManager imp1(&document1, getTestPath("OUT") + "/skgtestimportskg/all_types_exp_from_file.sqlite");
            SKGTESTERROR("SKG.exportFile", imp1.exportFile(), true);
        }
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "EXPORT_SKG", err);

            SKGImportExportManager imp1(&document1, getTestPath("OUT") + "/skgtestimportskg/all_types_exp_from_file.sqlite");
            SKGTESTERROR("SKG.exportFile", imp1.importFile(), true);
        }
    }

    //End test
    SKGENDTEST();
}
