/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    //Init test
    SKGINITTEST(true);

    //============================================================================
    {
        //Import
        SKGDocumentBank document1;
        SKGTESTERROR("document1.load()", document1.load(getTestPath("IN") + "skgtestbudget/budget.skg"), true);
        SKGError err;
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "BUDGET_CREATION", err);

            SKGTESTERROR("BUDGET.createAutomaticBudget", SKGBudgetObject::createAutomaticBudget(&document1, 2010, 2010, true, true, true), true);

        }
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "BUDGETRULE_CREATION", err);

            SKGBudgetRuleObject br(&document1);

            SKGTESTERROR("BUDGETRULE.enableYearCondition", br.enableYearCondition(true), true);
            SKGTEST("BUDGETRULE.isYearConditionEnabled", br.isYearConditionEnabled(), true);
            SKGTESTERROR("BUDGETRULE.enableYearCondition", br.enableYearCondition(false), true);
            SKGTEST("BUDGETRULE.isYearConditionEnabled", br.isYearConditionEnabled(), false);
            SKGTESTERROR("BUDGETRULE.setBudgetYear", br.setBudgetYear(2010), true);
            SKGTEST("BUDGETRULE.getBudgetYear", br.getBudgetYear(), 2010);

            SKGTESTERROR("BUDGETRULE.enableMonthCondition", br.enableMonthCondition(true), true);
            SKGTEST("BUDGETRULE.isMonthConditionEnabled", br.isMonthConditionEnabled(), true);
            SKGTESTERROR("BUDGETRULE.enableMonthCondition", br.enableMonthCondition(false), true);
            SKGTEST("BUDGETRULE.isMonthConditionEnabled", br.isMonthConditionEnabled(), false);
            SKGTESTERROR("BUDGETRULE.setBudgetMonth", br.setBudgetMonth(10), true);
            SKGTEST("BUDGETRULE.getBudgetMonth", br.getBudgetMonth(), 10);

            SKGTESTERROR("BUDGETRULE.enableCategoryCondition", br.enableCategoryCondition(true), true);
            SKGTEST("BUDGETRULE.isCategoryConditionEnabled", br.isCategoryConditionEnabled(), true);
            SKGCategoryObject cat;
            SKGTESTERROR("BUDGETRULE.createPathCategory", SKGCategoryObject::createPathCategory(&document1, "category_55 > category_57", cat), true);
            SKGTESTERROR("BUDGETRULE.setBudgetCategory", br.setBudgetCategory(cat), true);

            SKGTESTERROR("BUDGETRULE.setCondition", br.setCondition(SKGBudgetRuleObject::NEGATIVE), true);
            SKGTEST("BUDGETRULE.getCondition", br.getCondition(), SKGBudgetRuleObject::NEGATIVE);
            SKGTESTERROR("BUDGETRULE.setCondition", br.setCondition(SKGBudgetRuleObject::POSITIVE), true);
            SKGTEST("BUDGETRULE.getCondition", br.getCondition(), SKGBudgetRuleObject::POSITIVE);
            SKGTESTERROR("BUDGETRULE.setCondition", br.setCondition(SKGBudgetRuleObject::ALL), true);
            SKGTEST("BUDGETRULE.getCondition", br.getCondition(), SKGBudgetRuleObject::ALL);

            SKGTESTERROR("BUDGETRULE.setQuantity", br.setQuantity(100, false), true);
            SKGTEST("BUDGETRULE.getQuantity", br.getQuantity(), 100);
            SKGTEST("BUDGETRULE.isAbolute", br.isAbolute(), false);

            SKGTESTERROR("BUDGETRULE.setTransfer", br.setTransfer(SKGBudgetRuleObject::CURRENT), true);
            SKGTEST("BUDGETRULE.getTransferMode", br.getTransferMode(), SKGBudgetRuleObject::CURRENT);
            SKGTESTERROR("BUDGETRULE.setTransfer", br.setTransfer(SKGBudgetRuleObject::YEAR), true);
            SKGTEST("BUDGETRULE.getTransferMode", br.getTransferMode(), SKGBudgetRuleObject::YEAR);
            SKGTESTERROR("BUDGETRULE.setTransfer", br.setTransfer(SKGBudgetRuleObject::NEXT), true);
            SKGTEST("BUDGETRULE.getTransferMode", br.getTransferMode(), SKGBudgetRuleObject::NEXT);

            SKGTESTERROR("BUDGETRULE.save", br.save(), true);

            SKGBudgetRuleObject br2 = br;
            SKGBudgetRuleObject br3(br);
            SKGBudgetRuleObject br4((SKGObjectBase) br);

            SKGTESTERROR("BUDGETRULE.processAllRules", SKGBudgetRuleObject::processAllRules(&document1), true);
        }
        SKGTESTERROR("document1.saveAs()", document1.saveAs(getTestPath("OUT") + "skgtestbudget/budget.skg", true), true);
    }

    //End test
    SKGENDTEST();
}
