/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgimportexportmanager.h"
#include "skgbankincludes.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc);
    Q_UNUSED(argv);

    //Init test
    SKGINITTEST(true);

    {
        //Test import bankperfect
        SKGError err;
        SKGDocumentBank document1;
        SKGTESTERROR("document1.initialize()", document1.initialize(), true);
        {
            //Scope of the transaction
            SKGBEGINTRANSACTION(document1, "IMPORT_BP_CSV", err);
            SKGImportExportManager imp1(&document1, getTestPath("IN") + "/skgtestimportcsv/bankperfect.csv");
            SKGTESTERROR("imp1.importFile", imp1.importFile(), true);
        }

        {
            SKGBEGINTRANSACTION(document1, "AUTORECONCILE", err);
            SKGAccountObject account1(&document1);
            SKGTESTERROR("ACCOUNT.setName", account1.setName("bankperfect"), true);
            SKGTESTERROR("ACCOUNT.load", account1.load(), true);
            SKGTESTERROR("ACCOUNT.autoReconcile", account1.autoReconcile(3547.14), true);
        }
    }
    //End test
    SKGENDTEST();
}
