/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGIMPORTKMY_H
#define SKGIMPORTKMY_H
/** @file
 * This file defines classes SKGImportKmy.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgerror.h"
#include "skgbankmodeler_export.h"

#include <QObject>
#include <QSet>
class SKGDocumentBank;
class SKGUnitObject;
class SKGAccountObject;
class SKGCategoryObject;
class SKGOperationObject;
class SKGPayeeObject;
class QDomDocument;
class QDomElement;
class SKGImportExportManager;

/**
 *Manage import of KMYMONEY file
 */
class SKGBANKMODELER_EXPORT SKGImportKmy : public QObject
{
    Q_OBJECT;

public:
    /**
     * Import a kmy file.
     * @param iImporter the pointer on the importer.
     * @param iDocument the document where to import.
     * @return an object managing the error.
     *   @see SKGError
     */
    static SKGError importFile(SKGImportExportManager* iImporter, SKGDocumentBank* iDocument);

    /**
     * Export a kmy file.
     * @param iImporter the pointer on the importer.
     * @param iDocument the document to export.
     * @return an object managing the error.
     *   @see SKGError
     */
    static SKGError exportFile(SKGImportExportManager* iImporter, SKGDocumentBank* iDocument);

private:
    static SKGError exportOperation(const SKGOperationObject& iOperation, QDomDocument& iDoc, QDomElement& iTransaction);
    static QString kmyValue(double iValue);

    static QSet<QString>  m_opTreated;
    static QMap<QString, SKGUnitObject> m_mapIdUnit;
    static QMap<QString, SKGAccountObject> m_mapIdAccount;
    static QMap<QString, SKGCategoryObject> m_mapIdCategory;
    static QMap<QString, SKGPayeeObject> m_mapIdPayee;

};

#endif
