/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGQUERYCREATOR_H
#define SKGQUERYCREATOR_H
/** @file
 * A query creator for skrooge.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */

#include "ui_skgquerycreator.h"
#include "skgbankgui_export.h"

#include <QWidget>

class SKGDocument;


/**
 * This file is a query creator for skrooge
 */
class SKGBANKGUI_EXPORT SKGQueryCreator : public QWidget
{
    Q_OBJECT

public:
    /**
     * Default Constructor
     * @param parent the parent
     */
    SKGQueryCreator(QWidget *parent = 0);

    /**
     * Default Destructor
     */
    virtual ~SKGQueryCreator();

    /**
     * Set parameters
     * @param iDocument the document
     * @param iTable the table
     * @param iListAttribute the list of attribute (empty means all attributes supported of the table)
     * @param iModeUpdate to enable update mode
     */
    virtual void setParameters(SKGDocument* iDocument, const QString& iTable, const QStringList& iListAttribute = QStringList(), bool iModeUpdate = false);

    /**
     * Set XML representing the query
     * @param iXML the XML representing the query
     */
    virtual void setXMLCondition(const QString& iXML);

    /**
     * Get XML representing the query
     * @return the XML representing the query
     */
    virtual QString getXMLCondition();

public Q_SLOTS:
    /**
     * Clear table content
     */
    void clearContents();

private Q_SLOTS:
    void onRemoveLine(int iRow = -1);
    void onRemoveColumn(int iColumn = -1);
    void onCloseEditor();
    void onAddColumn();
private:
    Q_DISABLE_COPY(SKGQueryCreator);

    void addNewLine();
    int getIndexQueryColumn(const QString& iAttribute, int row = -1);
    void addColumnFromAttribut(const QListWidgetItem* listItem);

    Ui::skgquerycreator_base ui;
    SKGDocument* m_document;
    QString m_table;
    bool m_updateMode;
};

#endif // SKGQUERYCREATOR_H
