/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGOBJECTMODEL_H
#define SKGOBJECTMODEL_H
/** @file
 * This file defines classes SKGObjectModel.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbankgui_export.h"
#include "skgobjectmodelbase.h"
#include "skgobjectbase.h"
#include "skgdocumentbank.h"

#include <kglobal.h>

#include <QColor>
#include <QFont>

/**
 * The Table model managing SKGObjectBase
 */
class SKGBANKGUI_EXPORT SKGObjectModel : public SKGObjectModelBase
{
    Q_OBJECT
public:
    /**
     * Default constructor
     * @param iDocument the document where to search
     * @param iTable the table where to search
     * @param iWhereClause the where clause
     * @param parent parent QT object
     * @param iParentAttribute the attribute to find the parent of an object clause to find children
     * @param iResetOnCreation to reset data during creation
     */
    SKGObjectModel(SKGDocumentBank* iDocument,
                   const QString& iTable,
                   const QString& iWhereClause,
                   QObject *parent = NULL,
                   const QString& iParentAttribute = "",
                   bool iResetOnCreation = true);

    /**
     * Destructor
     */
    virtual ~SKGObjectModel();

    /**
     * Returns the data stored under the given role for the item referred to by the index.
     * @param index the index
     * @param role the role
     * @return the returned value
     */
    virtual QVariant data(const QModelIndex & index, int role = Qt::DisplayRole) const;

    /**
     * Sets the role data for the item at index to value. Returns true if successful; otherwise returns false.
     * @param index index of the object
     * @param value value
     * @param role role
     * @return
     */
    virtual bool setData(const QModelIndex & index, const QVariant & value, int role = Qt::EditRole);

    /**
     * Returns the data for the given role and section in the header with the specified orientation.
     * @param section the section
     * @param orientation the orientation
     * @param role the role
     * @return the header data
     */
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;

    /**
     * Returns the item flags for the given index.
     * @param index index of the object
     * @return flags of the given index
     */
    virtual Qt::ItemFlags flags(const QModelIndex &index) const;

    /**
     * Returns the actions supported by the data in this model.
     * @return Qt::DropActions
     */
    virtual Qt::DropActions supportedDragActions() const;

    /**
     * Returns the actions supported by the data in this model.
     * @return Qt::DropActions
     */
    virtual Qt::DropActions supportedDropActions() const;

    /**
     * Handles the data supplied by a drag and drop operation that ended with the given action.
     * Returns true if the data and action can be handled by the model; otherwise returns false.
     * Although the specified row, column and parent indicate the location of an item in the model where the operation ended,
     *it is the responsibility of the view to provide a suitable location for where the data should be inserted.
     * @param data mime data
     * @param action action
     * @param row row
     * @param column column
     * @param parent parent
     * @return true if the dropping was successful otherwise false.
     */
    virtual bool dropMimeData(const QMimeData *data,
                              Qt::DropAction action,
                              int row, int column,
                              const QModelIndex &parent);

protected Q_SLOTS:
    /**
     * This method is called by refresh to build the cache (to improve performance)
     */
    virtual void buidCache();

    /**
     * data are modified
     * @param iTableName table name
     * @param iIdTransaction the id of the transaction for direct modifications of the table (update of modify objects is enough)
     *or 0 in case of modifications by impact (full table must be refreshed)
     */
    virtual void dataModified(const QString& iTableName, int iIdTransaction);

private:
    Q_DISABLE_COPY(SKGObjectModel);

    SKGServices::SKGUnitInfo m_cacheUnit;
    bool m_operationTable;
    bool m_recurrentoperationTable;
    bool m_trackerTable;
    bool m_accountTable;
    bool m_unitTable;
    bool m_unitvalueTable;
    bool m_suboperationTable;
    bool m_categoryTable;
    bool m_ruleTable;
    bool m_interestTable;
    bool m_payeeTable;
    bool m_budgetTable;
    bool m_budgetRuleTable;

    QVariant m_fontDisabledScheduleColor;
    QVariant m_fontFutureOperationsColor;
    QVariant m_fontNotValidatedOperationsColor;
    QVariant m_fontSubOperationsColor;
    QVariant m_fontRedColor;

    QVariant m_iconTransfer;
    QVariant m_iconSplit;
    QVariant m_iconMuchMore;
    QVariant m_iconMuchLess;
    QVariant m_iconMore;
    QVariant m_iconLess;
    QVariant m_iconClosed;
    QVariant m_iconImported;
    QVariant m_iconImportedChecked;
    QVariant m_iconRecurrent;
    QVariant m_iconRecurrentMaster;
    QVariant m_iconFavorite;
    QVariant m_iconCategory;
    QVariant m_iconCategoryPlus;
    QVariant m_iconCategoryMoins;
    QVariant m_iconSearch;
    QVariant m_iconUpdate;
    QVariant m_iconAlarm;

    QVariant m_iconGreen;
    QVariant m_iconRed;
    QVariant m_iconAnber;
};

#endif
