/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Shares & Indexes Skroogoid
*
* @author Siddharth SHARMA
*/
#include "unitskroogoid.h"

#include "skgdocumentbank.h"
#include "skgtraces.h"
#include "skgservices.h"
#include "skgaccountobject.h"
#include "skgunitobject.h"
#include "skgmainpanel.h"

#include <QGraphicsLinearLayout>

UnitSkroogoid::UnitSkroogoid(QObject *parent, const QVariantList &args)
        : Plasma::PopupApplet(parent, args)
{

    setAspectRatioMode(Plasma::IgnoreAspectRatio);
    resize(300, 300);
    gl_layout = new QGraphicsLinearLayout();
    setLayout(gl_layout);

    KLocale* locale = KGlobal::locale();
    QString html;
    displayLabel = new Plasma::Label();
    SKGMainPanel* panel = SKGMainPanel::getMainPanel();
    SKGDocumentBank* doc = qobject_cast<SKGDocumentBank*>(panel->getDocument());
    SKGServices::SKGUnitInfo primary = doc->getPrimaryUnit();
    SKGObjectBase::SKGListSKGObjectBase objs;
    SKGError err = panel->getDocument()->getObjects( "v_unit_display", "1=1 ORDER BY t_type DESC, t_name ASC", objs);
    if (doc) {
        if (err.isSucceeded()) {
            QString html;
            html += "<html><body>";
            int nb = objs.count();
            if (nb) {
                html += "<table>";
                QString lastTitle;
                for (int i = 0; i < nb; ++i) {
                    SKGUnitObject obj = objs.at(i);
                    QString type = obj.getAttribute("t_TYPENLS");
                    if (lastTitle != type) {
                        lastTitle = type;
                        html += "<tr><td><b>" + SKGServices::stringToHtml(lastTitle) + "</b></td></tr>";
                    }
                    html += QString("<tr><td><a href=\"" + SKGServices::stringToHtml(obj.getSymbol()) + "\">") + SKGServices::stringToHtml(obj.getDisplayName()) + "</a></td><td align=\"right\">";
                    QString unitSymbol = primary.Symbol;
                    if (obj.getType() == SKGUnitObject::INDEX) unitSymbol = ' ';
                    html += SKGServices::stringToHtml(locale->formatMoney(SKGServices::stringToDouble(obj.getAttribute("f_CURRENTAMOUNT")), unitSymbol , primary.NbDecimal));
                    html += "</td><td>(";
                    double val = obj.getDailyChange();
                    html += "<font color=\"";
                    html += (val < 0 ? "red" : "black");
                    html += "\">";
                    html += SKGServices::stringToHtml(locale->formatNumber(val));
                    html += "</font> %)</td></tr>";
                }
                html += "</table>";
            } else {

                html += i18nc("Message", "No share or index defined<br>on the <a href=\"___\">\"Units\"</a> page.");
            }
            html += "</body></html>";
            displayLabel->setText(html);
            gl_layout->addItem(displayLabel);
        }
    }
}

UnitSkroogoid::~UnitSkroogoid()
{
}


#include "unitskroogoid.moc"
