/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGFILEPLUGIN_H
#define SKGFILEPLUGIN_H
/** @file
 * This file is a plugin for file operation.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skginterfaceplugin.h"
#include "ui_skgfilepluginwidget_pref.h"

#include <QObject>
#include <QVariantList>
#include <kgenericfactory.h>
#include <kurl.h>

class KAction;
class KRecentFilesAction;

class SKGMainPanel;

/**
 * This file is a plugin for file operation
 */
class SKGFilePlugin : public SKGInterfacePlugin
{
    Q_OBJECT
    Q_INTERFACES(SKGInterfacePlugin);

public:
    /**
     * Default Constructor
     */
    SKGFilePlugin(QObject* iParent, const QVariantList& iArg);

    /**
     * Default Destructor
     */
    virtual ~SKGFilePlugin();

    /**
     * Called to initialise the plugin
     * @param iDocument the main document
     * @param iArgument the arguments
     * @return true if the plugin is compatible with the document
     */
    virtual bool setupActions(SKGDocument* iDocument, const QStringList& iArgument);

    /**
     * This function is called when the application is launched again with new arguments
     * @param iArgument the arguments
     */
    virtual void processArguments(const QStringList& iArgument);

    /**
     * Must be modified to close properly the plugin.
     */
    virtual void close();

    /**
     * The preference widget of the plugin.
     * @return The preference widget of the plugin
     */
    virtual QWidget* getPreferenceWidget();

    /**
     * The preference skeleton of the plugin.
     * @return The preference skeleton of the plugin
     */
    virtual KConfigSkeleton* getPreferenceSkeleton();

    /**
     * This function is called when preferences have been modified. Must be used to save some parameters into the document.
     * A transaction is already opened
     * @return an object managing the error.
     *   @see SKGError
     */
    virtual SKGError savePreferences() const;

    /**
      * Must be modified to refresh widgets after a modification.
      */
    virtual void refresh();

    /**
     * The title of the plugin.
     * @return The title of the plugin
     */
    virtual QString title() const;

    /**
     * The icon of the plugin.
     * @return The icon of the plugin
     */
    virtual QString icon() const;

    /**
     * The toolTip of the plugin.
     * @return The toolTip of the plugin
     */
    virtual QString toolTip() const;

    /**
     * Must be implemented to set the position of the plugin.
     * @return integer value between 0 and 999 (default = 999)
     */
    virtual int getOrder() const;

    /**
     * The tips list of the plugin.
     * @return The tips list of the plugin
     */
    virtual QStringList tips() const;

    /**
     * The advice list of the plugin.
     * @return The advice list of the plugin
     */
    virtual QList<SKGInterfacePlugin::SKGAdvice> advices() const;

Q_SIGNALS:
    /**
     * request to load a file
     * @param iFile file name
     */
    void loadFile(const KUrl & iFile);

private Q_SLOTS:
    void actionOpen(const KUrl & iUrl = KUrl());
    void actionSave();
    void actionSaveAs();
    void actionNew();
    void actionChangePassword();
private:
    Q_DISABLE_COPY(SKGFilePlugin);

    KAction *m_saveAction;
    KAction *m_saveAsAction;
    KAction* m_passwordAction;
    KRecentFilesAction *m_recentFiles;

    SKGDocument* m_currentDocument;

    Ui::skgfileplugin_pref ui;
};

#endif // SKGFILEPLUGIN_H
